package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.NfcInterface;
import com.proximities.sdk.json.model.transmitter.BaseNfc;
import com.proximities.sdk.json.model.transmitter.Transmitter;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;

import java.util.List;
import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 05/09/16.
 */
public final class NfcRequest implements Response.Listener<BaseNfc>, Response.ErrorListener {

    private static final String TAG = makeLogTag(NfcRequest.class);
    private Context context;
    private String wsTransmitters;
    private NfcInterface mCallback;

    public NfcRequest(Context context, NfcInterface callback) {
        this.context = context;
        this.mCallback = callback;
        wsTransmitters = BuildConfig.HOST + context.getString(R.string.prxsc_ws_transmitter);
    }

    public void executeGet(String uuid, String major, String minor) {
        String url = wsTransmitters + "/" + uuid + "/" + major + "/" + minor;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BaseNfc> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseNfc.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseNfc baseNfc) {
        if(mCallback != null){
            List<Transmitter> transmitterList = baseNfc.getData().getTransmitters();
            if(transmitterList != null && transmitterList.size() > 0){
                mCallback.onGetNfcTransmitter(transmitterList.get(0));
            } else {
                mCallback.onNfcWithoutCampaign();
            }

        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null) mCallback.onGetNfcError();
    }

}
