package com.proximities.sdk.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.proximities.sdk.R;
import com.proximities.sdk.adapter.FavoritesAdapter;
import com.proximities.sdk.json.model.transmitter.Campaign;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 08/01/15.
 */

public class DefaultFavoritesFragment extends BaseFavoritesFragment{

    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recycler;
    private TextView reconnection;
    private LinearLayout mLayoutNoFavorites;
    private List<Campaign> favorites = new ArrayList<>();
    private FavoritesAdapter adapter;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.prxsc_default_fav_fragment, container, false);
        recycler = (RecyclerView) v.findViewById(R.id.recycler_fav);
        reconnection = (TextView) v.findViewById(R.id.reconnection);
        refreshLayout = (SwipeRefreshLayout) v.findViewById(R.id.swipe_container);
        mLayoutNoFavorites = (LinearLayout) v.findViewById(R.id.layout_no_favorites);
        refreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                refreshFavorites();
            }
        });
        reconnection.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                refreshFavorites();
            }
        });
        reconnection.setVisibility(View.GONE);
        recycler.setVisibility(View.VISIBLE);
        adapter = new FavoritesAdapter(getActivity(), favorites, this);
        recycler.setAdapter(adapter);
        return v;
    }

    @Override
    public void onResume() {
        super.onResume();
        refreshLayout.setRefreshing(true);
        refreshFavorites();
    }

    @Override
    public void onGetFavorites(List<Campaign> favorites) {
        super.onGetFavorites(favorites);
        refreshLayout.setRefreshing(true);
        reconnection.setVisibility(View.GONE);
        recycler.setVisibility(View.VISIBLE);
        this.favorites.clear();
        if(favorites != null && favorites.size() > 0){
            mLayoutNoFavorites.setVisibility(View.GONE);
            this.favorites.addAll(favorites);
        } else {
            mLayoutNoFavorites.setVisibility(View.VISIBLE);
        }
        adapter.notifyDataSetChanged();
        refreshLayout.setRefreshing(false);
    }

    @Override
    public void onGetFavoritesError() {
        super.onGetFavoritesError();
        refreshLayout.setRefreshing(false);
        reconnection.setVisibility(View.VISIBLE);
        recycler.setVisibility(View.GONE);
    }

    @Override
    public void onStart() {
        super.onStart();
        recycler.setLayoutManager(new GridLayoutManager(getActivity(), 2));
    }

    @Override
    public void onStop() {
        super.onStop();
    }

}
