package com.proximities.sdk.activities;

import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;

import com.proximities.sdk.BaseCampaignActivity;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.adapter.MultiCampaignsAdapter;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.Utils;

import java.util.ArrayList;

/**
 * Created by william on 06/12/16.
 */

public class MultiCampaignsActivity extends BaseCampaignActivity {

    private static final int CAMPAIGN_ACTIVITY_REQUEST_CODE = 10;

    private MultiCampaignsAdapter mAdapter;
    private int currentCampaignPosition = -1;
    private Drawable closeDrawable;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.prxsc_multi_campaigns_activity);
        initToolbarDisplay();
        ListView lvCampaigns = (ListView) findViewById(R.id.list_campaigns);
        mAdapter = new MultiCampaignsAdapter(this, getCampaigns());
        lvCampaigns.setAdapter(mAdapter);
        lvCampaigns.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                currentCampaignPosition = position;
                startCampaignActivity(getCampaigns().get(position));
            }
        });
    }

    @Override
    public void onBackPressed() {
        closeMultiCampaign();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if(requestCode == CAMPAIGN_ACTIVITY_REQUEST_CODE){
            closeDrawable.setColorFilter(new PorterDuffColorFilter(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_title), PorterDuff.Mode.MULTIPLY));
            getCampaigns().remove(currentCampaignPosition);
            mAdapter.notifyDataSetChanged();
            if(getCampaigns().size() == 0){
                closeMultiCampaign();
            }
        }
    }

    private void initToolbarDisplay(){
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        int colorItems = ContextCompat.getColor(this, R.color.prxsc_multi_campaign_title);
        TextView titleToolbar = (TextView) findViewById(R.id.title_toolbar);
        titleToolbar.setText(getString(R.string.prxsc_multi_campaigns_title));
        titleToolbar.setTextColor(colorItems);
        if(getSupportActionBar() != null){
            getSupportActionBar().setBackgroundDrawable(new ColorDrawable(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar)));
        }
        if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && Utils.isColorDark(R.color.prxsc_multi_campaign_toolbar)) {
            Window window = this.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar));
        }

        closeDrawable = ContextCompat.getDrawable(this, R.drawable.prxsc_ic_clear);
        closeDrawable.setColorFilter(new PorterDuffColorFilter(colorItems, PorterDuff.Mode.MULTIPLY));
        toolbar.setNavigationIcon(closeDrawable);
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
               closeMultiCampaign();
            }
        });
    }

    private void closeMultiCampaign(){
        if(getCampaigns().size() > 0){
            dismissCampaignView();
        }
        Utils.endCampaignDisplay(MultiCampaignsActivity.this, true);
    }

    private void startCampaignActivity(Campaign campaign){
        Intent intent;
        if(campaign.getTemplateType().equals(ProximitiesConfig.SIMPLE_CAMPAIGN)){
            intent = new Intent(this, SimpleNotificationActivity.class);
        } else {
            intent = new Intent(this, CampaignActivity.class);
        }
        intent.putExtra(ProximitiesConstants.IS_OPENING_FROM_MULTI_EXTRA, true);
        ArrayList<Campaign> campaigns = new ArrayList<>();
        campaigns.add(campaign);
        intent.putExtra(ProximitiesConstants.LIST_CAMPAIGNS_EXTRA, campaigns);
        intent.putExtra(ProximitiesConstants.CAMPAIGN_RECEIVED_EXTRA, true);
        startActivityForResult(intent, CAMPAIGN_ACTIVITY_REQUEST_CODE);
        overridePendingTransition(R.anim.zoom_in, R.anim.null_animation);
    }
}
