package com.proximities.sdk;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;

import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.List;

/**
 * Created by william on 13/12/16.
 */

public class BaseCampaignActivity extends AppCompatActivity {

    private List<Campaign> mCampaigns;
    private LogsManager mLogManager;
    private boolean isCampaignOpenByPush;
    private boolean isOpeningFromMulti;
    private boolean isCampaignReceived;
    private boolean isMultiCampaign;
    private String poiId;
    private String transmitterId;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        handleIntent(getIntent());
        if(isCampaignReceived){
            initLogs();
        }
        if(ProximitiesConfig.getOnOpenCampaignListener() != null && mCampaigns.size() == 1){
            ProximitiesConfig.getOnOpenCampaignListener().onOpenCampaign(this, mCampaigns.get(0), isCampaignReceived);
        }
    }

    public void handleIntent(Intent intent){
        if(intent.getExtras() != null) {
            mCampaigns = intent.getParcelableArrayListExtra(ProximitiesConstants.LIST_CAMPAIGNS_EXTRA);
            isCampaignOpenByPush = intent.getBooleanExtra(ProximitiesConstants.ANIM_BY_PUSH_EXTRA, false);
            isMultiCampaign = intent.getBooleanExtra(ProximitiesConstants.IS_MULTI_EXTRA, false);
            isOpeningFromMulti = intent.getBooleanExtra(ProximitiesConstants.IS_OPENING_FROM_MULTI_EXTRA, false);
            isCampaignReceived = intent.getBooleanExtra(ProximitiesConstants.CAMPAIGN_RECEIVED_EXTRA, false);
            poiId = intent.getStringExtra(ProximitiesConstants.POI_ID_EXTRA);
            transmitterId = intent.getStringExtra(ProximitiesConstants.TRANSMITTER_ID_EXTRA);
        }
    }

    public void dismissCampaignView(){
        if(isCampaignReceived) {
            mLogManager.generateLogs(mCampaigns, ProximitiesConstants.LOG_ACTION_DISMISS, poiId, transmitterId);
        }
    }

    public boolean isCampaignOpenByPush() {
        return isCampaignOpenByPush;
    }

    public boolean isCampaignReceived() {
        return isCampaignReceived;
    }

    public List<Campaign> getCampaigns() {
        return mCampaigns;
    }

    public boolean isOpeningFromMulti() {
        return isOpeningFromMulti;
    }

    public void removeCampaignFromDisplayList(Campaign campaign){
        PSManager.getInstance().removeCampaignFromDisplayedList(campaign);
    }

    private void initLogs(){
        mLogManager = LogsManager.getInstance();
        if(!isMultiCampaign){
            mLogManager.generateLogs(mCampaigns, ProximitiesConstants.LOG_ACTION_VIEWED, poiId, transmitterId);
        }
        if(isCampaignOpenByPush) {
            mLogManager.generateLogs(mCampaigns, ProximitiesConstants.LOG_ACTION_PUSH_ENGAGED, poiId, transmitterId);
        }
    }

    public void sendCustomLog(String action){
        mLogManager.generateLogsWithoutOrigins(mCampaigns, action);
    }

    @Override
    protected void onDestroy() {
        if(ProximitiesConfig.getOnCloseCampaignListener() != null) {
            ProximitiesConfig.getOnCloseCampaignListener().onCloseCampaign(isCampaignReceived, mCampaigns);
        }
        super.onDestroy();
    }
}
