package com.proximities.sdk.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.bridge.OnCustomClick;
import com.proximities.sdk.json.model.transmitter.Campaign;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by William Mouliné on 21/03/17.
 */

public class FavoritesAdapter extends RecyclerView.Adapter<FavoritesAdapter.AnimationViewHolder> implements OnCustomClick {

    private Context mContext;
    private List<Campaign> animations;
    private OnAnimationListener listener;

    public class AnimationViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        OnCustomClick myListener;
        ImageView image;
        TextView topbarTitle;
        TextView timeleft;

        public AnimationViewHolder(View itemView, OnCustomClick listener) {
            super(itemView);
            itemView.setOnClickListener(this);
            myListener = listener;
            image = (ImageView) itemView.findViewById(R.id.image);
            topbarTitle = (TextView) itemView.findViewById(R.id.topbar_title);
            timeleft = (TextView) itemView.findViewById(R.id.text_timeleft);

        }

        @Override
        public void onClick(View view) {
            myListener.onClickAt(getAdapterPosition());
        }
    }

    public FavoritesAdapter(Context context, List<Campaign> animations, OnAnimationListener listener) {
        this.mContext = context;
        this.listener = listener;
        if (animations == null) {
            this.animations = new ArrayList<>();
        } else {
            this.animations = animations;
        }
    }

    @Override
    public AnimationViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.
                from(parent.getContext()).
                inflate(R.layout.prxsc_fav_item, parent, false);
        return new FavoritesAdapter.AnimationViewHolder(itemView, this);
    }

    @Override
    public void onBindViewHolder(final AnimationViewHolder holder,final int position) {
        Campaign animation = animations.get(position);
        String url = BuildConfig.HOST + animation.getImage();
        if(animation.getTemplateType().equals(ProximitiesConfig.AUDIO_CAMPAIGN)){
            loadImageFullSize(url, holder, com.proximities.sdk.R.drawable.default_audio);
        }else if(animation.getTemplateType().equals(ProximitiesConfig.WEB_CAMPAIGN)){
            loadImageFullSize(url, holder, com.proximities.sdk.R.drawable.default_webview);
        } else if (animation.getImage() != null && !animation.getImage().isEmpty()) {
            holder.image.setVisibility(View.VISIBLE);
            Glide.with(mContext).load(url).placeholder(android.R.color.white).into(holder.image);
            holder.image.setBackgroundColor(Color.parseColor(animation.getContentBackgroundColor()));
        } else {
            Glide.with(mContext).load(android.R.color.white).into(holder.image);
        }

        if (animation.getTopbarTitle() != null && !animation.getTopbarTitle().isEmpty()) {
            holder.topbarTitle.setVisibility(View.VISIBLE);
            holder.topbarTitle.setText(animation.getTopbarTitle());
        } else {
            holder.topbarTitle.setVisibility(View.GONE);
        }

        try {

            Calendar now = Calendar.getInstance();
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar endDate = new GregorianCalendar();
            endDate.setTime(formater.parse(animation.getEndDate()));

            long diff = endDate.getTimeInMillis() - now.getTimeInMillis();
            int result = Math.round(diff / (60 * 60 * 1000));

            if (result < 1)
                holder.timeleft.setText(String.format(mContext.getString(R.string.prxsc_favorites_timeleft), mContext.getString(R.string.prxsc_timeleft_one_hour)));
            else if (result / 24 < 1)
                holder.timeleft.setText(String.format(mContext.getString(R.string.prxsc_favorites_timeleft),String.format(mContext.getResources().getQuantityString(R.plurals.prxsc_timeleft_only_hours, result), result)));
            else
                holder.timeleft.setText(String.format(mContext.getString(R.string.prxsc_favorites_timeleft),String.format(mContext.getResources().getQuantityString(R.plurals.prxsc_timeleft_notif, Math.round(TimeUnit.HOURS.toDays(result))), Math.round(TimeUnit.HOURS.toDays(result)))));
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (NullPointerException e1){
            e1.printStackTrace();
        }
    }

    private void loadImageFullSize(String url, final AnimationViewHolder holder,final  int resource){
        Glide.with(mContext).load(url).asBitmap().placeholder(resource).diskCacheStrategy(DiskCacheStrategy.ALL)
                .into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        holder.image.setImageBitmap(resource);
                    }

                    @Override
                    public void onLoadFailed(Exception e, Drawable errorDrawable) {
                        super.onLoadFailed(e, errorDrawable);
                        holder.image.setImageDrawable(ContextCompat.getDrawable(mContext, resource));
                    }
                });
    }

    private String substractDates(Date date1, Date date2, SimpleDateFormat format)
    {
        long restDatesinMillis = date1.getTime()-date2.getTime();
        Date restdate = new Date(restDatesinMillis);

        return format.format(restdate);

    }

    @Override
    public int getItemCount() {
        return animations.size();
    }

    @Override
    public void onClickAt(int position) {
        listener.onClickAnimation(animations.get(position));
    }

}
