package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.ProximitiesGpsManager;
import com.proximities.sdk.json.model.closest_poi.BaseClosestPoi;
import com.proximities.sdk.json.model.partner.PartnerError;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 23/11/15.
 */
public final class ClosestPoiRequest implements Response.Listener<BaseClosestPoi>, Response.ErrorListener {

    private static final String TAG = makeLogTag(ClosestPoiRequest.class);

    private static ClosestPoiRequest ourInstance;
    private Context mContext;

    public static ClosestPoiRequest getInstance(Context ctx) {
        if (ourInstance == null) {
            ourInstance = new ClosestPoiRequest(ctx);
        }
        return ourInstance;
    }

    private ClosestPoiRequest() {
    }

    private ClosestPoiRequest(Context ctx) {
        this.mContext = ctx;
    }


    public void executeGetForClosestPoi(double latitude, double longitude) {
        String url = ProximitiesConstants.access().getWS_CLOSEST_POI() + "/" + latitude + "/" + longitude;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(mContext, "GET&" + url);
        GsonRequest<BaseClosestPoi> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseClosestPoi.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(DefaultRetryPolicy.DEFAULT_TIMEOUT_MS * 2, DefaultRetryPolicy.DEFAULT_MAX_RETRIES, DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseClosestPoi baseClosestPoi) {
        if(baseClosestPoi != null) ProximitiesGpsManager.getInstance().updateLocationRequest(baseClosestPoi.getData().getDistance());
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        EventBus.getDefault().post(new PartnerError());
    }
}

