package com.proximities.sdk.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by william on 23/06/15.
 */
public class AnimationListAdapter extends BaseAdapter{

    private static final int TRUNCATE_VALUE = 75;
    private Context ctx;
    private List<Campaign> campaigns;
    private LayoutInflater inflater;

    public AnimationListAdapter(Context context, List<Campaign> campaigns) {
        this.ctx = context;
        if (campaigns == null) {
            this.campaigns = new ArrayList<>();
        } else {
            this.campaigns = campaigns;
        }
        inflater = LayoutInflater.from(this.ctx);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final AnimViewHolder holder;
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.animation_list_item, parent, false);
            holder = new AnimViewHolder(convertView);
            convertView.setTag(holder);
        } else {
            holder = (AnimViewHolder) convertView.getTag();
        }

        Campaign anim = getItem(position);
        if(anim.getImage() != null && !anim.getImage().isEmpty()){
            Glide.with(ctx).load(ProximitiesConstants.STATIC_CONTENT_HOST + anim.getImage()).asBitmap().centerCrop().into(new BitmapImageViewTarget(holder.image) {
                @Override
                protected void setResource(Bitmap resource) {
                    RoundedBitmapDrawable circularBitmapDrawable =
                            RoundedBitmapDrawableFactory.create(ctx.getResources(), resource);
                    circularBitmapDrawable.setCircular(true);
                    holder.image.setImageDrawable(circularBitmapDrawable);
                }
            });
        } else {
            int resource = android.R.color.transparent;
            switch(anim.getTemplateType()){
                case ProximitiesConstants.SIMPLE_NOTIF:
                    resource = R.drawable.default_notif_simple;
                    break;
                case ProximitiesConstants.RICH_NOTIF:
                    resource = R.drawable.default_notif_rich;
                    break;
                case ProximitiesConstants.AUDIO_NOTIF:
                    resource = R.drawable.default_notif_audio;
                    break;
                case ProximitiesConstants.VIDEO_NOTIF:
                    resource = R.drawable.default_notif_video;
                    break;
                case ProximitiesConstants.WEBVIEW_NOTIF:
                    resource = R.drawable.default_notif_webview;
                    break;
        }
        Glide.with(ctx).load(resource).asBitmap().into(holder.image);

    }
        holder.poiName.setText(anim.getPoiName());
        holder.content.setText(anim.getTitle());
        return convertView;
    }

    private String truncateTitle(String title){
        String truncateTitle = title;
        if(title.length() > TRUNCATE_VALUE){
            truncateTitle = truncateTitle.substring(0,TRUNCATE_VALUE-1);
        }
        return truncateTitle;
    }

    @Override
    public Campaign getItem(int position) {
        return campaigns.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public int getCount() {
        return campaigns.size();
    }

    private class AnimViewHolder {
        ImageView image;
        TextView poiName;
        TextView content;

        public AnimViewHolder(View item) {
            image = (ImageView) item.findViewById(R.id.image);
            poiName = (TextView) item.findViewById(R.id.poi_name);
            content = (TextView) item.findViewById(R.id.content);
        }
    }


}
