package com.proximities.sdk;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.proximities.sdk.util.ProximitiesPrefs;
import com.proximities.sdk.util.Utils;

/**
 * Created by william on 28/10/15.
 */
public class SettingsActivity extends AppCompatActivity {

    private static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION = 1;

    private boolean isGpsEnabled;
    private boolean isBluetoothEnabled;
    private boolean isWifiEnabled;
    private TextView wifiText;
    private TextView bluetoothText;
    private TextView bluetoothExplanation;
    private TextView wifiExplanation;
    private SwitchCompat switchBluetooth;
    private SwitchCompat switchWifi;
    private Button btnConfirm;
    private Button btnEnableGps;
    private CheckBox doNotAskAgain;
    private TextView textExplanation;
    private TextView textGpsDisabled;
    private LinearLayout layoutPermission;
    private WifiManager wifi;
    private BluetoothAdapter mBluetoothAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        ProximitiesConfig.disableAllCampaigns(this, true);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.settings_activity);
        setTitle(getResources().getString(R.string.settings) + " " + getResources().getString(R.string.app_name));
        switchBluetooth = (SwitchCompat) findViewById(R.id.switch_bluetooth);
        switchWifi = (SwitchCompat) findViewById(R.id.switch_wifi);
        btnConfirm = (Button) findViewById(R.id.confirm);
        btnEnableGps = (Button) findViewById(R.id.btn_enable_gps);
        doNotAskAgain = (CheckBox) findViewById(R.id.do_not_ask_again);
        textExplanation = (TextView) findViewById(R.id.text_explanation);
        textGpsDisabled = (TextView) findViewById(R.id.text_gps_disabled);
        wifiExplanation = (TextView) findViewById(R.id.explanation_wifi);
        bluetoothExplanation = (TextView) findViewById(R.id.explanation_bluetooth);
        wifiText = (TextView) findViewById(R.id.wifi);
        bluetoothText = (TextView) findViewById(R.id.bluetooth);
        layoutPermission = (LinearLayout) findViewById(R.id.layout_permission);

        wifi = (WifiManager) getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        initFunctionalities();

        btnEnableGps.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent callGPSSettingIntent = new Intent(
                        android.provider.Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                startActivity(callGPSSettingIntent);
            }
        });

        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                switchFunctionalities();
                if (ContextCompat.checkSelfPermission(SettingsActivity.this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                    Intent i = new Intent(SettingsActivity.this, PermissionDialogActivity.class);
                    i.putExtra("from_settings", true);
                    i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    startActivity(i);
                } else {
                    LocationManager locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
                    if (locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
                        Intent i = new Intent(SettingsActivity.this, ProximitiesService.class);
                        startService(i);
                    }
                }
                finish();
                ProximitiesConfig.disableAllCampaigns(SettingsActivity.this, false);
            }
        });
    }

    private void initFunctionalities(){
        if(wifi.isWifiEnabled()) {
            isWifiEnabled = true;
            wifiExplanation.setVisibility(View.GONE);
            switchWifi.setVisibility(View.GONE);
            wifiText.setVisibility(View.GONE);
        } else {
            isWifiEnabled = false;
            switchWifi.setChecked(true);
        }


        if(Utils.isBluetoothAvailable()) {
            isBluetoothEnabled = true;
            bluetoothExplanation.setVisibility(View.GONE);
            switchBluetooth.setVisibility(View.GONE);
            bluetoothText.setVisibility(View.GONE);
        } else {
            isBluetoothEnabled = false;
            switchBluetooth.setChecked(true);
        }

        checkGpsState();

        if (ContextCompat.checkSelfPermission(SettingsActivity.this, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
            }else{
                textExplanation.setVisibility(View.GONE);
            }
        }
    }

    private void switchFunctionalities(){
        if(switchBluetooth.getVisibility() == View.VISIBLE) {
            if (isBluetoothEnabled != switchBluetooth.isChecked()) {
                if(mBluetoothAdapter != null) {
                    if (switchBluetooth.isChecked()) {
                        mBluetoothAdapter.enable();
                    } else {
                        if(Utils.isBluetoothAvailable()){
                            mBluetoothAdapter.disable();
                        }
                    }
                }
            }
        }

        if(switchWifi.getVisibility() == View.VISIBLE) {
            if (isWifiEnabled != switchWifi.isChecked()) {
                if (switchWifi.isChecked()) {
                    wifi.setWifiEnabled(true);
                } else {
                    wifi.setWifiEnabled(false);
                }
            }
        }

        if (doNotAskAgain.isChecked()) {  // do not ask again
            ProximitiesPrefs.writeAskBleAgain(this, false);
        } else {
            ProximitiesPrefs.writeAskBleAgain(this, true);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION: {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    if (ProximitiesConfig.getOnAccessLocationListener() != null)
                        ProximitiesConfig.getOnAccessLocationListener().onAccessLocationGranted();
                } else {

                }
            }
        }
    }

    private void checkGpsState(){
        LocationManager locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
        if (locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            isGpsEnabled = true;
            textGpsDisabled.setVisibility(View.GONE);
            btnEnableGps.setVisibility(View.GONE);
        } else {
            isGpsEnabled = false;
            textGpsDisabled.setVisibility(View.VISIBLE);
            btnEnableGps.setVisibility(View.VISIBLE);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        checkGpsState();
    }

    @Override
    public void onBackPressed() {

    }
}
