package com.proximities.sdk;

import android.Manifest;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.google.gson.Gson;
import com.proximities.sdk.util.PermissionGpsUtil;

/**
 * Created by william on 14/10/15.
 */
public class PermissionDialogActivity extends AppCompatActivity{

    private static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION = 5;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.permission_dialog_activity);
        if(ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED){
            /*if(!getIntent().getBooleanExtra("from_settings", false)) {
                LayoutInflater factory = LayoutInflater.from(this);
                final View dialogView = factory.inflate(R.layout.explanation_permission_dialog, null);
                final AlertDialog dialog = new AlertDialog.Builder(this).create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.setView(dialogView);

                final TextView errorText = (TextView) dialogView.findViewById(R.id.text_explanation);
                errorText.setText(getResources().getString(R.string.explanation_permission));

                final Button buttonDenied = (Button) dialogView.findViewById(R.id.btn_denied);
                buttonDenied.setTextColor(ContextCompat.getColor(this, ProximitiesConfig.getInstance().getColorToolbarCampaigns()));
                buttonDenied.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dialog.dismiss();
                        finish();
                        if (ProximitiesConfig.getOnAccessLocationListener() != null)
                            ProximitiesConfig.getOnAccessLocationListener().onAccessLocationDenied();
                    }
                });

                final Button buttonOk = (Button) dialogView.findViewById(R.id.btn_ok);
                buttonOk.setTextColor(ContextCompat.getColor(this, ProximitiesConfig.getInstance().getColorToolbarCampaigns()));
                buttonOk.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dialog.dismiss();
                        ActivityCompat.requestPermissions(PermissionDialogActivity.this, new String[]{Manifest.permission.ACCESS_FINE_LOCATION},
                                MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION);
                    }
                });

                dialog.show();
            } else {*/
                ActivityCompat.requestPermissions(PermissionDialogActivity.this, new String[]{Manifest.permission.ACCESS_FINE_LOCATION},
                        MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION);
//            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION: {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    Intent i = new Intent(this, ProximitiesService.class);
                    this.startService(i);
                    finish();
                    if(ProximitiesConfig.getOnAccessLocationListener() != null)
                        ProximitiesConfig.getOnAccessLocationListener().onAccessLocationGranted();
                } else {
                    finish();
                    if(ProximitiesConfig.getOnAccessLocationListener() != null)
                        ProximitiesConfig.getOnAccessLocationListener().onAccessLocationDenied();
                }
            }
        }
    }


}
