package com.proximities.sdk.request.api;

import android.app.Activity;

import com.proximities.sdk.json.model.category.ExcludedBaseCategories;
import com.proximities.sdk.json.model.category.ExcludedCategoriesError;
import com.proximities.sdk.json.model.category.ExcludedCategoriesSuccess;
import com.proximities.sdk.json.model.partner.ExcludedBasePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by victo_000 on 29/01/2015.
 */
public class ExcludedCategoryRequest implements Response.Listener<ExcludedBaseCategories>, Response.ErrorListener {
    private static final String TAG = makeLogTag(ExcludedCategoryRequest.class);

    private static ExcludedCategoryRequest ourInstance;
    private static int methodHttp;
    private Activity ctx;

    public static ExcludedCategoryRequest getInstance(Activity ctx) {
        if (ourInstance == null) {
            ourInstance = new ExcludedCategoryRequest(ctx);
        }
        return ourInstance;
    }

    private ExcludedCategoryRequest() {}
    private ExcludedCategoryRequest(Activity ctx) {
        this.ctx = ctx;
    }

    public void executeGet() {
        methodHttp = Request.Method.GET;
        String url = ProximitiesConstants.access().getWS_EXCLUDED_CATEGORIES();
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "GET&" + url);
        GsonRequest<ExcludedBaseCategories> request = new GsonRequest(
                Request.Method.GET,
                url,
                ExcludedBaseCategories.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executePost(List<Integer> excludedCategories) {
        methodHttp = Request.Method.POST;
        String url = ProximitiesConstants.access().getWS_EXCLUDED_CATEGORIES();
        LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeaderWithoutAnonymous(ctx, "POST&" + url);
        Map<String, List<Integer>> body = new HashMap<>();
        body.put("datas", excludedCategories);
        GsonRequest<ExcludedBasePartner> request = new GsonRequest(
                Request.Method.POST,
                url,
                body,
                ExcludedBaseCategories.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(ExcludedBaseCategories result) {
        if(result != null) {
            EventBus.getDefault().post(result);
        } else {
            EventBus.getDefault().post(new ExcludedCategoriesSuccess());
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        /*NetworkResponse response = volleyError.networkResponse;
        if (response != null && response.data != null) {
            switch (response.statusCode) {
                case 400 :
                    ErrorData errorData = new Gson().fromJson(new String(response.data), ErrorData.class);
                    errorData.setStatusCode(response.statusCode);
                    EventBus.getDefault().post(errorData);
                    break;
            }
        }*/
        EventBus.getDefault().post(new ExcludedCategoriesError());
    }
}