package com.proximities.sdk;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Patterns;

import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;
import com.proximities.sdk.request.api.QRCodeRequest;

/**
 * Created by william on 22/08/16.
 */
public class ScannerQrActivity extends Activity{


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.scanner_qr_activity);

        startScanner();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, intent);
        if (scanResult != null && resultCode == RESULT_OK) {
            handleContentQr(scanResult.getContents());
        } else {
            finish();
        }
    }

    private void startScanner(){
        IntentIntegrator intentIntegrator = new IntentIntegrator(this);
//        intentIntegrator.setScanningRectangle(800,800);
        intentIntegrator.initiateScan();
    }

    private void handleContentQr(String contentQr){
        if(Patterns.WEB_URL.matcher(contentQr).matches()) {
            try {
                contentQr = (!contentQr.startsWith("http://") && !contentQr.startsWith("https://")) ? "http://"+contentQr : contentQr;
                Intent i = new Intent("android.intent.action.MAIN");
                i.setComponent(ComponentName.unflattenFromString("com.android.chrome/com.android.chrome.Main"));
                i.addCategory("android.intent.category.LAUNCHER");
                i.setData(Uri.parse(contentQr));
                startActivity(i);
            }
            catch(ActivityNotFoundException e1) {
                try{
                    Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(contentQr));
                    startActivity(i);
                } catch (ActivityNotFoundException e2) {
                    if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onErrorOnQrCodeResponse();
                }
            }
        } else if (contentQr.startsWith(getResources().getString(R.string.qr_code_prefix))){
            Uri content = Uri.parse(contentQr);
            QRCodeRequest qrCodeRequest = new QRCodeRequest();
            if(content.getQueryParameter("uuid") != null && !content.getQueryParameter("uuid").isEmpty()
                    && content.getQueryParameter("maj") != null && !content.getQueryParameter("maj").isEmpty()
                    && content.getQueryParameter("min") != null && !content.getQueryParameter("min").isEmpty()) {
                qrCodeRequest.executeGet(content.getQueryParameter("uuid"), content.getQueryParameter("maj"), content.getQueryParameter("min"));
            }
        } else {
            if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onUnknownQrCodeResponse();
        }
        finish();
    }
}
