package com.proximities.sdk;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.bridge.OnUrlRequestListener;
import com.proximities.sdk.fragment.AnimFragment;
import com.proximities.sdk.fragment.AnimListFragment;
import com.proximities.sdk.fragment.AudioAnimation;
import com.proximities.sdk.fragment.VideoAnimation;
import com.proximities.sdk.fragment.dialog.SimplePushFragment;
import com.proximities.sdk.fragment.dialog.DelAnimFragment;
import com.proximities.sdk.fragment.dialog.DelListAnimFragment;
import com.proximities.sdk.json.model.animation.DeletedAnimation;
import com.proximities.sdk.json.model.animation.SavedAnimation;
import com.proximities.sdk.json.model.log.AnimationLog;
import com.proximities.sdk.json.model.transmitter.BaseNfc;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.json.model.transmitter.BaseTransmitter;
import com.proximities.sdk.request.api.AnimationRequest;
import com.proximities.sdk.request.api.LogRequest;
import com.proximities.sdk.request.api.NfcRequest;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.ProximitiesPrefs;
import com.proximities.sdk.util.Utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.LOGE;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 27/12/14.
 */
public class ProximitiesAnimationActivity extends AppCompatActivity implements DelAnimFragment.DelAnimListener,
        DelListAnimFragment.DelAnimListListener,
        OnAnimationListener, OnUrlRequestListener {

    private static final String TAG = makeLogTag(ProximitiesAnimationActivity.class);
    private static final String ANIM_FRAGMENT_STACK_NAME = "anim_fragment";
    private static final String TOPBAR_FAVORITES = "favorites";
    private static final String NO_TOPBAR_BUTTON = "none";

    private RelativeLayout mainLayout;
    private Toolbar toolBar;
    private FrameLayout mainContent;
    private ProgressBar progressBar;
    private TextView emptyAnim;
    private TextView titleAnim;
    private RelativeLayout urlView;
    private WebView webView;
    private ImageView close;
    private ProgressBar spinner;

    private List<Campaign> campaigns;
    private Campaign currentAnim;

    //private FrameLayout animActivity;
    private boolean isFavAnim;
    private Menu menu;
    private MenuItem actionButton;
    private Drawable actionButtonDrawable;
    private int actionButtonValue;

    private Intent intent;

    private boolean isAnimOpened = false;
    private boolean isMulti;
    private boolean isAnimByPush= false;
    private boolean containsAnims = false;
    private boolean isSimpleInBackground = false;
    private boolean isVideoAnimInFullScreen = false;
    private boolean isFragmentRecreated = false;
    private boolean isRequiringActionButtonSetUp = false;
    private boolean isNfcAnimationDetected = false;
    private boolean isCampaignReceived = false;

    private Bundle savedInstanceState;
    private Bundle saveCurrentAnimation;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        intent = getIntent();
        initAnimationsAndTheme();
        super.onCreate(savedInstanceState);
        this.savedInstanceState = savedInstanceState;
        setContentView(R.layout.proximities_animation_activity);
        initComponents();
    }

    private void initAnimationsAndTheme(){
        if (intent.getExtras() != null && intent.getExtras().get(ProximitiesConstants.EXTRA_ANIMS) != null) {
            isAnimByPush = intent.getBooleanExtra(ProximitiesConstants.ANIM_BY_PUSH, false);
            containsAnims = true;
            campaigns = intent.getParcelableArrayListExtra(ProximitiesConstants.EXTRA_ANIMS);
            isCampaignReceived = intent.getBooleanExtra(ProximitiesConstants.CAMPAIGN_RECEIVED_EXTRA, false);
//            isFragmentRecreated = intent.getBooleanExtra("recreated", false);
            if(campaigns != null && campaigns.size() == 1 && campaigns.get(0).getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF)){
                isSimpleInBackground = intent.getExtras().getBoolean(ProximitiesConstants.IS_BACKGROUND, false);
                if(!isSimpleInBackground && !ProximitiesConfig.getInstance().isDialogBeforeDeepLinkEnabled()){
                    if(ProximitiesConfig.getOnCatchIdentifierListener() != null) ProximitiesConfig.getOnCatchIdentifierListener().onCatchIdentifier(campaigns.get(0).getIdentifier());
                    else if(ProximitiesConfig.getOnHandleSimpleAnimationListener() != null) ProximitiesConfig.getOnHandleSimpleAnimationListener().onHandleIdentifier(campaigns.get(0).getIdentifier());
                    manageLog(campaigns, ProximitiesConstants.ANIM_RECEIVED);
                    finish();
                }
            } else {
                this.setTheme(R.style.CustomToolBar);
            }
        } else if(intent.getAction() != null && intent.getAction().equals(NfcAdapter.ACTION_NDEF_DISCOVERED)){
            this.setTheme(R.style.CustomToolBar);
        }
    }

    private void initComponents(){
        if(savedInstanceState != null)
            currentAnim = savedInstanceState.getParcelable("currentAnimation");
        isFavAnim = intent.getBooleanExtra(ProximitiesConstants.EXTRA_DELETE_OPTION, false);
        actionButtonValue = intent.getIntExtra(ProximitiesConstants.EXTRA_ACTION_BUTTON_VALUE, -1);
        mainLayout = (RelativeLayout) findViewById(R.id.main_layout);
        mainContent = (FrameLayout) findViewById(R.id.main_content);
        toolBar = (Toolbar) findViewById(R.id.toolbar);
        progressBar = (ProgressBar) findViewById(R.id.progress_bar);
        emptyAnim = (TextView) findViewById(R.id.empty_anim);

        urlView = (RelativeLayout) findViewById(R.id.url_view);
        webView = (WebView) findViewById(R.id.webview);
        spinner = (ProgressBar) findViewById(R.id.spinner);
        close = (ImageView) findViewById(R.id.close);
        close.setColorFilter(new PorterDuffColorFilter(ContextCompat.getColor(this, android.R.color.black), PorterDuff.Mode.SRC_ATOP));
        close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                urlView.setVisibility(View.GONE);
                mainContent.setVisibility(View.VISIBLE);
            }
        });
        setSupportActionBar(toolBar);
        toolBar.setNavigationIcon(R.drawable.ic_clear);
        titleAnim = (TextView) findViewById(R.id.title_anim);
        NfcAdapter mAdapter = NfcAdapter.getDefaultAdapter(this);
        if(isSimpleInBackground){
            try {
                Intent i;
                if(ProximitiesConfig.getInstance().isUsingCurrentActivity()){
                    i = new Intent(this, Class.forName(ProximitiesConfig.getInstance().getCurrentActivity()));
                    i.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
                }else{
                    i = new Intent(this, Class.forName(ProximitiesConfig.getMainActivity(this)));
                }
                startActivity(i);
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if(ProximitiesConfig.getOnCatchIdentifierListener() != null) ProximitiesConfig.getOnCatchIdentifierListener().onCatchIdentifier(campaigns.get(0).getIdentifier());
            else if(ProximitiesConfig.getOnHandleSimpleAnimationListener() != null) ProximitiesConfig.getOnHandleSimpleAnimationListener().onHandleIdentifier(campaigns.get(0).getIdentifier());
            this.finish();
        }
        if (intent.getAction() != null && intent.getAction().equals(NfcAdapter.ACTION_NDEF_DISCOVERED)) {
            NfcRequest request = new NfcRequest();
            final Uri uri = intent.getData();
            String currentUuidNfc = uri.getQueryParameter("uuid");
            String currentMajorNfc = uri.getQueryParameter("maj");
            String currentMinordNfc = uri.getQueryParameter("min");
            request.executeGet(currentUuidNfc, currentMajorNfc, currentMinordNfc);
        } else if (containsAnims && !isAnimOpened) {
            chooseFragmentToDisplay();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if(!EventBus.getDefault().isRegistered(this))
            EventBus.getDefault().register(this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent.getExtras() != null && intent.getExtras().get(ProximitiesConstants.EXTRA_ANIMS) != null) {
            isAnimByPush = intent.getBooleanExtra(ProximitiesConstants.ANIM_BY_PUSH, false);
            containsAnims = true;
            List<Campaign> newCampaigns = intent.getParcelableArrayListExtra(ProximitiesConstants.EXTRA_ANIMS);
            if (isAnimByPush && campaigns != null && !campaigns.isEmpty()) {
                manageLog(newCampaigns, ProximitiesConstants.PUSH_ENGAGED);
                boolean areDuplicates = false;
                for(Campaign anim : campaigns){
                    for (Campaign newAnim: newCampaigns){
                        if(anim.getId() == newAnim.getId())
                            areDuplicates = true;
                    }
                }
                if(!areDuplicates) {
                    campaigns.addAll(newCampaigns);
                    int count = getSupportFragmentManager().getBackStackEntryCount();
                    for(int i = 0; i < count; ++i) {
                        getSupportFragmentManager().popBackStack();
                    }
                    isFragmentRecreated = true;
                    chooseFragmentToDisplay();
                } else if (campaigns.size() == 1){
                    addStampWhenCampaignOpened(newCampaigns);
                }
            } else { // refresh loyalty from a transmitter
                if(newCampaigns != null && newCampaigns.size() == 1 && newCampaigns.get(0).getTemplateType().equals(ProximitiesConstants.LOYALTY_NOTIF)
                        && currentAnim != null && currentAnim.getId() == newCampaigns.get(0).getId())
                    manageLog(newCampaigns, ProximitiesConstants.ANIM_RECEIVED);
            }
        } else if (intent.getAction() != null && intent.getAction().equals(NfcAdapter.ACTION_NDEF_DISCOVERED) && (currentAnim == null || !currentAnim.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF))) {
            isNfcAnimationDetected = true;
            final Uri uri = intent.getData();
            String uuid = uri.getQueryParameter("uuid");
            String major = uri.getQueryParameter("maj");
            String minor = uri.getQueryParameter("min");
            NfcRequest nfcRequest = new NfcRequest();
            nfcRequest.executeGet(uuid, major, minor);
        }
    }

    private void addStampWhenCampaignOpened(List<Campaign> newAnims){
        if(newAnims != null && newAnims.size() == 1 && newAnims.get(0).getTemplateType().equals(ProximitiesConstants.LOYALTY_NOTIF)
                 && (currentAnim != null && currentAnim.getId() == newAnims.get(0).getId() || isNfcAnimationDetected)){
            isNfcAnimationDetected = false;

            if(!isMulti) {
                campaigns = newAnims;
            } else {
                manageLog(newAnims, ProximitiesConstants.ANIM_RECEIVED);
                campaigns.remove(currentAnim);
                campaigns.add(newAnims.get(0));
            }

            int count = getSupportFragmentManager().getBackStackEntryCount();
            for(int i = 0; i < count; ++i) {
                getSupportFragmentManager().popBackStack();
            }
            isFragmentRecreated = true;
            chooseFragmentToDisplay();

            if(isMulti) onClickAnimation(newAnims.get(0));
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        getMenuInflater().inflate(R.menu.animation_menu, menu);
        this.menu = menu;
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.action_button) {
            if((ProximitiesConfig.getOnManageMenuAnimationListener() == null || ProximitiesConfig.getOnCustomMenuCampaignListener() == null)
                    && !ProximitiesConfig.getInstance().isFavDisable() && currentAnim.getTopbarButton().equals(TOPBAR_FAVORITES)) {
                if(actionButtonValue == 1) {
                    AnimationRequest animReq = AnimationRequest.getInstance(getApplication());
                    animReq.executeDel(currentAnim.getId());
                } else {
                    AnimationRequest animReq = AnimationRequest.getInstance(getApplication());
                    animReq.executePost(currentAnim.getId());
                }
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void favoritesAddedWithSuccess(){
        Drawable itemFull = ContextCompat.getDrawable(this, ProximitiesConfig.getInstance().getAddFavoritesResource());
        if(ProximitiesConfig.getInstance().isUsingColorFilter()) itemFull.setColorFilter(new PorterDuffColorFilter(Color.parseColor(currentAnim.getTopbarFontColor()), PorterDuff.Mode.MULTIPLY));
        actionButton.setIcon(itemFull);
        actionButtonValue = 1;
    }

    private void favoritesDeletedWithSuccess(){
        Drawable itemEmpty = ContextCompat.getDrawable(this, ProximitiesConfig.getInstance().getDelFavoritesResource());
        if(ProximitiesConfig.getInstance().isUsingColorFilter()) itemEmpty.setColorFilter(new PorterDuffColorFilter(Color.parseColor(currentAnim.getTopbarFontColor()), PorterDuff.Mode.MULTIPLY));
        actionButton.setIcon(itemEmpty);
        actionButtonValue = 0;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        actionButton = menu.findItem(R.id.action_button);
        if(isRequiringActionButtonSetUp){
            setActionButton();
            isRequiringActionButtonSetUp = false;
        }
        if(actionButton != null) {
            if (actionButtonDrawable != null) {
                actionButton.setIcon(actionButtonDrawable);
                actionButton.setVisible(true);
            } else {
                actionButton.setVisible(false);
            }
        }
        return super.onPrepareOptionsMenu(menu);
    }

    /**
     * Here, we have two choices :
     * -> campaigns contains only one animation ==> go to {@link com.proximities.sdk.fragment.AnimFragment}
     * -> campaigns contains 2 or more campaigns ==> go to {@link com.proximities.sdk.fragment.AnimListFragment}
     */
    private void chooseFragmentToDisplay() {
        isAnimOpened = true;
        progressBar.setVisibility(View.GONE);

        if(!isFavAnim && !isAnimByPush && actionButtonValue == -1 && !isFragmentRecreated){
            manageLog(campaigns, ProximitiesConstants.ANIM_RECEIVED);
        }
        if(isAnimByPush && !isFragmentRecreated)
            manageLog(campaigns, ProximitiesConstants.PUSH_ENGAGED);

        if (campaigns != null && campaigns.size() == 0) {
            actionButtonDrawable = null;
            emptyView();
        } else if (campaigns != null && campaigns.size() == 1) {
            currentAnim = campaigns.get(0);
            // Send Campaign to fragment
            EventBus.getDefault().postSticky(currentAnim);
            if(currentAnim.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF)){
                if(getSupportActionBar() != null)
                    getSupportActionBar().hide();
                loadSimplePush();
            } else {
                // Toolbar customized by customer :)
                //setTitle(currentAnim.getTopbarTitle());
                titleAnim.setText(currentAnim.getTopbarTitle());
                int textAndIconsColor = Color.parseColor(currentAnim.getTopbarFontColor());
                titleAnim.setTextColor(textAndIconsColor);
                //toolBar.setTitleTextColor(textAndIconsColor);
                if (getSupportActionBar() != null) getSupportActionBar().setBackgroundDrawable(new ColorDrawable(Color.parseColor(currentAnim.getTopbarBackgroundColor())));
                if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && Utils.isColorDark(Color.parseColor(currentAnim.getTopbarBackgroundColor()))) {
                    Window window = this.getWindow();
                    window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                    window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
                    window.setStatusBarColor(Color.parseColor(currentAnim.getTopbarBackgroundColor()));
                }
                Drawable closeDrawable = ContextCompat.getDrawable(this, R.drawable.ic_clear);
                closeDrawable.setColorFilter(new PorterDuffColorFilter(textAndIconsColor, PorterDuff.Mode.MULTIPLY));
                toolBar.setNavigationIcon(closeDrawable);
                toolBar.setNavigationOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        onBackPressed();
                    }
                });
                isRequiringActionButtonSetUp = true;
                //setActionButton();
                if (ProximitiesConfig.getInstance().isFavDisable() || (currentAnim.getTopbarButton() != null && currentAnim.getTopbarButton().equals("none")))
                    actionButtonDrawable = null;
                supportInvalidateOptionsMenu();

                loadAnim();
            }
        } else if (campaigns != null && campaigns.size() > 0) {
            actionButtonDrawable = null;
            // Send list of Campaign to fragment
            EventBus.getDefault().postSticky(campaigns);
            isMulti = true;
            loadAnimList();
        }
        supportInvalidateOptionsMenu();
    }

    private void setActionButton(){
        if(ProximitiesConfig.getOnCustomMenuCampaignListener() != null){
            if(actionButton != null) {
                ProximitiesConfig.getOnCustomMenuCampaignListener().customizeMenu(menu);
            }
        } else if (ProximitiesConfig.getOnManageMenuAnimationListener() != null) {
            if(actionButton != null) {
                ProximitiesConfig.getOnManageMenuAnimationListener().onManageMenu(menu);
            }
        } else if(!ProximitiesConfig.getInstance().isFavDisable() && currentAnim.getTopbarButton().equals(TOPBAR_FAVORITES)){
            if (actionButtonValue == 1) {
                Drawable itemEmpty = ContextCompat.getDrawable(this, ProximitiesConfig.getInstance().getAddFavoritesResource());
                if(ProximitiesConfig.getInstance().isUsingColorFilter()) itemEmpty.setColorFilter(new PorterDuffColorFilter(Color.parseColor(currentAnim.getTopbarFontColor()), PorterDuff.Mode.MULTIPLY));
                actionButtonDrawable = itemEmpty;
            } else {
                Drawable itemFull = ContextCompat.getDrawable(this, ProximitiesConfig.getInstance().getDelFavoritesResource());
                if(ProximitiesConfig.getInstance().isUsingColorFilter()) itemFull.setColorFilter(new PorterDuffColorFilter(Color.parseColor(currentAnim.getTopbarFontColor()), PorterDuff.Mode.MULTIPLY));
                actionButtonDrawable = itemFull;
            }
        } else if(ProximitiesConfig.getInstance().isFavDisable() || currentAnim.getTopbarButton().equals(NO_TOPBAR_BUTTON)){
            actionButtonDrawable = new ColorDrawable(ContextCompat.getColor(this, android.R.color.transparent));
        }
    }



    @Override
    public void onClikDel() {
        AnimationRequest animReq = AnimationRequest.getInstance(getApplication());
        animReq.executeDel(currentAnim.getId());
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        saveCurrentAnimation = outState;
    }

    public void loadAnim() {
        if(isCampaignReceived && ProximitiesConfig.getOnOpenCampaignListener() != null){
            ProximitiesConfig.getOnOpenCampaignListener().onOpenCampaign(this, currentAnim);
        }
        if(currentAnim.getTemplateType().equals(ProximitiesConstants.AUDIO_NOTIF)){
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.main_content, AudioAnimation.newInstance(this))
                    .addToBackStack("audio_anim")
                    .commit();
        } else if (currentAnim.getTemplateType().equals(ProximitiesConstants.VIDEO_NOTIF)){
            if(savedInstanceState == null) {
                ProximitiesPrefs.writeTimeVideo(this, 0);
                getSupportFragmentManager().beginTransaction()
                        .add(R.id.main_content, VideoAnimation.newInstance(this))
                        .addToBackStack("video_anim")
                        .commit();
            } else {
                if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                            WindowManager.LayoutParams.FLAG_FULLSCREEN);
                    toolBar.setVisibility(View.GONE);
                    isVideoAnimInFullScreen = true;
                } else {
                    toolBar.setVisibility(View.VISIBLE);
                    isVideoAnimInFullScreen = false;
                }
            }
        } else {
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.main_content, AnimFragment.newInstance(this))
                    .addToBackStack(ANIM_FRAGMENT_STACK_NAME)
                    .commit();
        }
    }

    private void loadAnimList() {
        prepareToolbarForMultiAnim();
        FragmentManager fragmentManager = getSupportFragmentManager();
        fragmentManager.beginTransaction()
                .replace(R.id.main_content, AnimListFragment.newInstance())
                .addToBackStack("multiAnim")
                .commit();
    }

    private void loadSimplePush() {
        SimplePushFragment spf = SimplePushFragment.newInstance(isMulti, campaigns);
        spf.show(getSupportFragmentManager(), "simplePush");
    }

    /**
     * Logs are a way to make statistics in the BO. This function
     * save some information about user's behavior about
     * {@link Campaign}
     *
     * @param anim  Campaign which is impacted
     * @param userAction  kind of behavior. It can take three values :
     *                    {@value com.proximities.sdk.util.ProximitiesConstants#ANIM_RECEIVED}
     *                    {@value com.proximities.sdk.util.ProximitiesConstants#SAVED}
     *                    {@value com.proximities.sdk.util.ProximitiesConstants#DISMISS}
     */
    private void manageLog(Campaign anim, String userAction) {
        if(isCampaignReceived) {
            AnimationLog animLog = new AnimationLog();
            animLog.setUserAction(userAction);
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            animLog.setCreated(format.format(calendar.getTime()));
            List<Integer> animIds = new ArrayList<>(1);
            animIds.add(anim.getId());
            animLog.setAnimationsIds(animIds);
            LogRequest logReq = LogRequest.getInstance(getApplication());
            logReq.executePost(animLog);
        }
    }

    public void manageLog(List<Campaign> campaigns, String userAction) {
        if(isCampaignReceived) {
            AnimationLog animLog = new AnimationLog();
            animLog.setUserAction(userAction);
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            animLog.setCreated(format.format(calendar.getTime()));
            List<Integer> animIds = new ArrayList<>();
            for (Campaign anim : campaigns) {
                if (!anim.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF) || (!userAction.equals(ProximitiesConstants.DISMISS) && anim.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF))) {
                    animIds.add(anim.getId());
                    animLog.setAnimationsIds(animIds);
                }
            }
            LogRequest logReq = LogRequest.getInstance(getApplication());
            logReq.executePost(animLog);
        }
    }

    private void emptyView() {
        progressBar.setVisibility(View.GONE);
        emptyAnim.setVisibility(View.VISIBLE);
    }

    /**
     * Callback on GET {@link com.proximities.sdk.util.ProximitiesConstants#WS_TRANSMITTERS} with success
     *
     * @param data  {@link BaseTransmitter} object
     * @see com.proximities.sdk.request.api.TransmitterRequest
     */
    @Subscribe
    public void onEventMainThread(BaseTransmitter data) {
        if (!data.getData().getTransmitters().isEmpty()){
            if(!isAnimOpened) {
                ProximitiesConstants.STATIC_CONTENT_HOST = data.getServerUrl();
                campaigns = data.getData().getTransmitters().get(0).getCampaigns();
                chooseFragmentToDisplay();
            } else {
                addStampWhenCampaignOpened(data.getData().getTransmitters().get(0).getCampaigns());
            }
        }
    }

    @Subscribe
    public void onEventMainThread(BaseNfc data){
        if (!data.getData().getTransmitters().isEmpty()){
            if(!isAnimOpened) {
                ProximitiesConstants.STATIC_CONTENT_HOST = data.getServerUrl();
                campaigns = data.getData().getTransmitters().get(0).getCampaigns();
                chooseFragmentToDisplay();
            } else {
                addStampWhenCampaignOpened(data.getData().getTransmitters().get(0).getCampaigns());
            }
        } else {
            if(!isAnimOpened) {
                prepareCustomToolbar();
                progressBar.setVisibility(View.GONE);
                emptyView();
            } else {
                Snackbar.make(mainLayout, getString(R.string.empty_anim), Snackbar.LENGTH_SHORT ).show();
            }
        }
    }

    /**
     * Callback on POST {@link com.proximities.sdk.util.ProximitiesConstants#WS_ANIM} with success
     *
     * @param data  {@link SavedAnimation} object
     * @see com.proximities.sdk.request.api.AnimationRequest
     */
    @Subscribe
    public void onEventMainThread(SavedAnimation data) {
        favoritesAddedWithSuccess();
        Snackbar.make(mainLayout, R.string.anim_add_to_fav, Snackbar.LENGTH_SHORT).show();
    }

    /**
     * Callback on DELETE {@link com.proximities.sdk.util.ProximitiesConstants#WS_ANIM} with success
     *
     * @param data  {@link DeletedAnimation} object
     * @see com.proximities.sdk.request.api.AnimationRequest
     */
    @Subscribe
    public void onEventMainThread(DeletedAnimation data) {
        favoritesDeletedWithSuccess();
        Snackbar.make(mainLayout, R.string.anim_del_of_fav, Snackbar.LENGTH_SHORT).show();
    }

    @Override
    public void onStop() {
        EventBus.getDefault().unregister(this);
        super.onStop();
    }

    private void prepareCustomToolbar(){
        int textColor = ContextCompat.getColor(this, ProximitiesConfig.getInstance().getColorTitleCampaigns());
        titleAnim.setTextColor(textColor);
        if(getSupportActionBar() != null)
            getSupportActionBar().setBackgroundDrawable(new ColorDrawable(ContextCompat.getColor(this, ProximitiesConfig.getInstance().getColorToolbarCampaigns())));
        if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && Utils.isColorDark(ProximitiesConfig.getInstance().getColorToolbarCampaigns())) {
            Window window = this.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(ContextCompat.getColor(this, ProximitiesConfig.getInstance().getColorToolbarCampaigns()));
        }

        Drawable closeDrawable = ContextCompat.getDrawable(this, R.drawable.ic_clear);
        closeDrawable.setColorFilter(new PorterDuffColorFilter(textColor, PorterDuff.Mode.MULTIPLY));
        toolBar.setNavigationIcon(closeDrawable);
        toolBar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onBackPressed();
            }
        });
        supportInvalidateOptionsMenu();
    }

    /**
     * Toolbar for multi animation contains some specifications
     */
    private void prepareToolbarForMultiAnim() {
        titleAnim.setText(ProximitiesConfig.getInstance().getTitleCampaigns());
        prepareCustomToolbar();
    }

    @Override
    public void displayUrlView(String url){
        /*WebSettings settings = webView.getSettings();
        settings.setJavaScriptEnabled(true);
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                spinner.setVisibility(View.GONE);
            }
        });
        webView.loadUrl(url);
        urlView.setVisibility(View.VISIBLE);*/
        Intent intent = new Intent(this, WebViewActivity.class);
        intent.putExtra(ProximitiesConstants.EXTRA_URL, url);
        startActivity(intent);
    }

    @Override
    public void onClickAnimation(Campaign anim) {
        currentAnim = anim;
        // Send Campaign to fragment
        EventBus.getDefault().postSticky(currentAnim);

        if(currentAnim.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF)){
            loadSimplePush();
        } else {
            // Toolbar customized by customer :)
            titleAnim.setText(currentAnim.getTopbarTitle());
            int textAndIconsColor = Color.parseColor(currentAnim.getTopbarFontColor());
            titleAnim.setTextColor(textAndIconsColor);
            if(getSupportActionBar() != null)
                getSupportActionBar().setBackgroundDrawable(new ColorDrawable(Color.parseColor(currentAnim.getTopbarBackgroundColor())));
            if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && Utils.isColorDark(Color.parseColor(currentAnim.getTopbarBackgroundColor()))) {
                Window window = this.getWindow();
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
                window.setStatusBarColor(Color.parseColor(currentAnim.getTopbarBackgroundColor()));
            }
            Drawable closeDrawable = ContextCompat.getDrawable(this, R.drawable.ic_clear);
            closeDrawable.setColorFilter(new PorterDuffColorFilter(textAndIconsColor, PorterDuff.Mode.MULTIPLY));
            toolBar.setNavigationIcon(closeDrawable);
            toolBar.setNavigationOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    campaigns.remove(currentAnim);
                    if (actionButtonValue != 1) {
                        manageLog(currentAnim, ProximitiesConstants.DISMISS);
                    }
                    if (ProximitiesConfig.getOnManageMenuAnimationListener() == null || ProximitiesConfig.getOnCustomMenuCampaignListener() == null){
                        actionButtonValue = -1;
                    }
                    actionButtonDrawable = null;
                    //manageLog(currentAnim, ProximitiesConstants.DISMISS);
                    if (campaigns.size() == 0) {
                        sendIntent();
                    } else {
//                        EventBus.getDefault().postSticky(campaigns);
                        prepareToolbarForMultiAnim();
                        onBackPressed();
                    }
                }
            });

            if (isMulti) {
                isFavAnim = false;
            }

            setActionButton();

            if(ProximitiesConfig.getInstance().isFavDisable() || (currentAnim.getTopbarButton() != null && currentAnim.getTopbarButton().equals("none")))
                actionButtonDrawable = null;
            supportInvalidateOptionsMenu();
            loadAnim();
        }
    }

    private void sendIntent(){
        Intent intent = null;
        try {
            intent = new Intent(this, Class.forName(ProximitiesConfig.getMainActivity(this)));
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if(ProximitiesConfig.getInstance().isUsingCurrentActivity()){
            try {
                Intent i = new Intent(this, Class.forName(ProximitiesConfig.getInstance().getCurrentActivity()));
                i.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
                this.startActivity(i);
            }catch (ClassNotFoundException e){
                e.printStackTrace();
            }
        }else{
            if(intent != null) {
                //intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_NEW_TASK);
                startActivity(intent);
            }
        }
        if(!isFavAnim && actionButtonValue != 1) {
            manageLog(campaigns, ProximitiesConstants.DISMISS);
        }
        if(isCampaignReceived && ProximitiesConfig.getOnCloseReceivedCampaignListener() != null){
            ProximitiesConfig.getOnCloseReceivedCampaignListener().onCloseCampaign();
        }
        finish();
    }

    @Override
    public void onBackPressed() {
        LOGD(TAG, "onBackPressed");
        if(isVideoAnimInFullScreen){
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        } else {
            if (getSupportFragmentManager().getBackStackEntryCount() == 1) {
                if (isMulti) {
                    DelListAnimFragment dlg = DelListAnimFragment.newInstance();
                    dlg.show(getSupportFragmentManager(), "delList");
                } else {
                    try {
                        sendIntent();
                    } catch (ActivityNotFoundException e) {
                        LOGE(TAG, "No intent filter declared to match to com.proximities.sdk.RUN");
                    }
                }
            } else {
                super.onBackPressed();
                if (isMulti){
                    prepareToolbarForMultiAnim();
                }
            }
        }
    }

    @Override
    public void onClikDelList() {
        try {
            sendIntent();
        } catch (ActivityNotFoundException e) {
            LOGE(TAG, "No intent filter declared to match to com.proximities.sdk.RUN");
        }
    }
}
