/*
 * Decompiled with CFR 0.152.
 */
package com.proximities.sdk.fragment;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.proximities.sdk.R;
import com.proximities.sdk.a.b;
import com.proximities.sdk.fragment.BaseFavoritesFragment;
import com.proximities.sdk.json.model.transmitter.Campaign;
import java.util.ArrayList;
import java.util.List;

public class FavoritesFragment
extends BaseFavoritesFragment {
    private SwipeRefreshLayout refreshLayout;
    private ProgressBar spinner;
    private RecyclerView recycler;
    private TextView reconnection;
    private List<Campaign> favorites = new ArrayList<Campaign>();
    private b adapter;
    private Campaign defaultAnim;
    private static String urlDefaultFavorite;

    public static FavoritesFragment newInstance(String string2) {
        urlDefaultFavorite = string2;
        return new FavoritesFragment();
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.fav_fragment, viewGroup, false);
        this.recycler = (RecyclerView)view.findViewById(R.id.recycler_fav);
        this.reconnection = (TextView)view.findViewById(R.id.reconnection);
        this.spinner = (ProgressBar)view.findViewById(R.id.spinner);
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_container);
        this.refreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                FavoritesFragment.this.refreshFavorites();
            }
        });
        this.spinner.getIndeterminateDrawable().setColorFilter(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.orange), PorterDuff.Mode.MULTIPLY);
        this.reconnection.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FavoritesFragment.this.refreshFavorites();
            }
        });
        this.reconnection.setVisibility(8);
        this.recycler.setVisibility(0);
        this.defaultAnim = new Campaign();
        this.setEmptyFavorites();
        this.adapter = new b((Context)this.getActivity(), this.favorites, this);
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.spinner.setVisibility(0);
        this.refreshFavorites();
    }

    @Override
    public void onReceiveFavorites(List<Campaign> list) {
        super.onReceiveFavorites(list);
        this.refreshLayout.setRefreshing(true);
        this.reconnection.setVisibility(8);
        this.spinner.setVisibility(8);
        this.recycler.setVisibility(0);
        this.favorites.clear();
        if (list != null && list.size() > 0) {
            this.favorites.addAll(list);
        } else {
            this.favorites.add(this.defaultAnim);
        }
        this.adapter.notifyDataSetChanged();
        this.refreshLayout.setRefreshing(false);
    }

    @Override
    public void onErrorCallbackFavorites() {
        super.onErrorCallbackFavorites();
        this.spinner.setVisibility(8);
        this.reconnection.setVisibility(0);
        this.recycler.setVisibility(8);
    }

    private void setEmptyFavorites() {
        this.defaultAnim.setTitle(this.getResources().getString(R.string.welcome));
        this.defaultAnim.setType("information");
        this.defaultAnim.setContentBackgroundColor("#FFFFFF");
        this.defaultAnim.setContentFontColor("#000000");
        this.defaultAnim.setTopbarFontColor("#000000");
        this.defaultAnim.setTopbarBackgroundColor("#FFFFFF");
        this.defaultAnim.setTopbarTitle(this.getResources().getString(R.string.welcome));
        this.defaultAnim.setContentText("<center>" + this.getResources().getString(R.string.anim_example_content) + "</center>");
        this.defaultAnim.setContentTitle(this.getResources().getString(R.string.anim_example_title));
        this.defaultAnim.setTemplateType("rich-notification");
        this.defaultAnim.setTopbarButton("favorites");
        this.defaultAnim.setBanner("");
        this.defaultAnim.setImage(urlDefaultFavorite);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.getActivity(), 2));
    }

    @Override
    public void onStop() {
        super.onStop();
    }
}

