package com.proximities.sdk.request.api;

import android.app.Application;
import com.proximities.sdk.bridge.OnProximitiesService;
import com.proximities.sdk.database.DatabaseHandler;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.json.model.transmitter.BaseTransmitter;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 28/12/14.
 */
public final class TransmitterRequest implements Response.Listener<BaseTransmitter>, Response.ErrorListener {

    private static final String TAG = makeLogTag(TransmitterRequest.class);

    private static TransmitterRequest ourInstance;
    private Application app;
    private String uuid;
    private String major;
    private String minor;
    private String namespace;
    private String instance;
    private static OnProximitiesService onProximitiesService;

    public static TransmitterRequest getInstance(Application app, OnProximitiesService callback) {
        if (ourInstance == null) {
            ourInstance = new TransmitterRequest(app);
            onProximitiesService =  callback;
        }
        return ourInstance;
    }

    public static TransmitterRequest getInstance(Application app) {
        if (ourInstance == null) {
            ourInstance = new TransmitterRequest(app);
        }
        return ourInstance;
    }


    private TransmitterRequest() {}
    private TransmitterRequest(Application app) {
        this.app = app;
    }

    public void executeGet(String uuid, String major, String minor) {
        this.uuid = uuid;
        this.major = major;
        this.minor = minor;
        String url = ProximitiesConstants.access().getWS_TRANSMITTERS() + "/" + uuid + "/" + major + "/" + minor;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app.getApplicationContext(), "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseTransmitter.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executeGet(String namespace, String instance) {
        this.namespace = namespace;
        this.instance = instance;
        String url = ProximitiesConstants.access().getWS_TRANSMITTERS() + "/" + namespace + "/" + instance;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app.getApplicationContext(), "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseTransmitter.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseTransmitter baseTransmitter) {
       if (baseTransmitter != null) {
           ProximitiesConstants.STATIC_CONTENT_HOST = baseTransmitter.getServerUrl();
           EventBus.getDefault().post(baseTransmitter);
       }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(onProximitiesService != null) {
            DatabaseHandler dbHandler = new DatabaseHandler(app.getApplicationContext());
            dbHandler.startAnimFromDatabase(uuid, minor, major, namespace, instance, onProximitiesService);
            dbHandler.close();
        }
    }

}
