package com.proximities.sdk.request.api;

import android.app.Activity;

import com.proximities.sdk.json.model.user.BaseRegisterUser;
import com.proximities.sdk.json.model.user.RegisterUserSuccess;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by victo_000 on 21/12/2014.
 */
public class RegisterUserRequest implements Response.Listener<BaseRegisterUser>, Response.ErrorListener{

    private static final String TAG = makeLogTag(RegisterUserRequest.class);
    private static int methodHttp;

    public RegisterUserRequest() {
    }

    public void sendRegisterUser(Map<String, Object> body) {
        methodHttp = Request.Method.POST;
        String url = ProximitiesConstants.access().getWS_SEGMENTATION_USER();
        LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ApplicationUtil.getMyInstance().getMyApp(), "POST&" + url);
        GsonRequest<BaseRegisterUser> request = new GsonRequest(
                Request.Method.POST,
                url,
                body,
                BaseRegisterUser.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void updateRegisterUser(Map<String, Object> body) {
        methodHttp = Request.Method.PUT;
        String url = ProximitiesConstants.access().getWS_SEGMENTATION_USER();
        LOGD(TAG, "PUT: " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ApplicationUtil.getMyInstance().getMyApp(), "PUT&" + url);
        GsonRequest<BaseRegisterUser> request = new GsonRequest(
                Request.Method.PUT,
                url,
                body,
                BaseRegisterUser.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        EventBus.getDefault().post(volleyError);
    }

    @Override
    public void onResponse(BaseRegisterUser baseUser) {
        EventBus.getDefault().postSticky(new RegisterUserSuccess());
    }
}