package com.proximities.sdk.request.api;

import android.app.Application;

import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 01/01/15.
 */
public final class PartnerRequest extends WsHeader implements Response.Listener<BasePartner>, Response.ErrorListener {

    private static final String TAG = makeLogTag(PartnerRequest.class);

    private static PartnerRequest ourInstance;
    private Application app;

    public static PartnerRequest getInstance(Application app) {
        if (ourInstance == null) {
            ourInstance = new PartnerRequest(app);
        }
        return ourInstance;
    }

    private PartnerRequest() {}
    private PartnerRequest(Application app) {
        this.app = app;
    }

    public void executeGet(double latitude, double longitude) {

        String url = ProximitiesConstants.access().getWS_PARTNER() + "/" + latitude + "/" + longitude;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app.getApplicationContext(), "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BasePartner.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executeGet(double latitude, double longitude, boolean calledFromGps) {
        String url = ProximitiesConstants.access().getWS_PARTNER() + "/" + latitude + "/" + longitude;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app.getApplicationContext(), "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BasePartner.class,
                params,
                this,
                this,
                calledFromGps);
        //request.setRetryPolicy(new DefaultRetryPolicy(0, DefaultRetryPolicy.DEFAULT_MAX_RETRIES, DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BasePartner basePartner) {
        if(basePartner != null) {
            ProximitiesConstants.STATIC_CONTENT_HOST = basePartner.getServerUrl();
            LOGD(TAG, "static url : " + basePartner.getServerUrl());
        }
        EventBus.getDefault().post(basePartner);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
    }
}
