package com.proximities.sdk.util;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.proximities.sdk.ProximitiesConfig;

import org.altbeacon.beacon.powersave.BackgroundPowerSaver;

/**
 * Created by william on 11/08/16.
 */
public class ApplicationUtil {

    private static final String CAMPAIGN_CLASS_NAME = "com.proximities.sdk.ProximitiesAnimationActivity";
    private static final String WEBVIEW_CLASS_NAME = "com.proximities.sdk.WebViewActivity";

    public static ApplicationUtil getMyInstance() {
        return myInstance;
    }

    private static ApplicationUtil myInstance;
    private RequestQueue mRequestQueue;
    private BackgroundPowerSaver backgroundPowerSaver;
    private boolean isResumed;
    private Application myApp;


    public static void newInstance(Application app){
        if(myInstance == null) myInstance = new ApplicationUtil(app);
    }

    public ApplicationUtil(Application app){
        myApp = app;
        mRequestQueue = Volley.newRequestQueue(app);
        // Register to be notified of activity state changes
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

            }

            @Override
            public void onActivityStarted(Activity activity) {

            }

            @Override
            public void onActivityResumed(Activity activity) {
                if(!activity.getClass().getCanonicalName().equals(CAMPAIGN_CLASS_NAME)
                        && !activity.getClass().getCanonicalName().equals(WEBVIEW_CLASS_NAME) ){
                    ProximitiesConfig.getInstance().saveCurrentActivity(activity.getClass());
                }
                isResumed = true;
            }

            @Override
            public void onActivityPaused(Activity activity) {
                isResumed = false;
            }

            @Override
            public void onActivityStopped(Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(Activity activity) {

            }
        });
        if(!Utils.isIncompatibleDevice()) backgroundPowerSaver = new BackgroundPowerSaver(app);
    }

    public RequestQueue getRequestQueue() {
        return mRequestQueue;
    }

    public Application getMyApp() {
        return myApp;
    }

    public boolean isResumed() {
        return isResumed;
    }
}
