package com.proximities.sdk.request.api;

import android.app.Application;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.json.model.loyalty.BaseLoyalty;
import com.proximities.sdk.json.model.loyalty.LoyaltyError;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.LogUtils;
import com.proximities.sdk.util.ProximitiesConstants;

import org.greenrobot.eventbus.EventBus;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;

/**
 * Created by william on 23/02/16.
 */
public class LoyaltyRequest implements Response.Listener<BaseLoyalty>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(LoyaltyRequest.class);

    private static LoyaltyRequest ourInstance;
    private Application ctx;

    public static LoyaltyRequest getInstance(Application ctx) {
        if (ourInstance == null) {
            ourInstance = new LoyaltyRequest(ctx);
        }
        return ourInstance;
    }

    private LoyaltyRequest() {}
    private LoyaltyRequest(Application ctx) {
        this.ctx = ctx;
    }

    public void executePost(int animId) {
        String url = ProximitiesConstants.access().getWS_LOYALTY() + "/" + animId + "/refresh";
        LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + url);
        GsonRequest<BaseLoyalty> request = new GsonRequest(
                Request.Method.POST,
                url,
                BaseLoyalty.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseLoyalty baseLoyalty) {
        ProximitiesConstants.STATIC_CONTENT_HOST = baseLoyalty.getServerUrl();
        LOGD(TAG, "static url : " + baseLoyalty.getServerUrl());
        EventBus.getDefault().post(baseLoyalty);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        EventBus.getDefault().post(new LoyaltyError());
    }
}
