package com.proximities.sdk.request.api;

import android.app.Application;

import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.partner.BaseFavoritePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by victo_000 on 12/02/2015.
 */
public class PartnerFavoriteRequest extends WsHeader implements Response.Listener<BaseFavoritePartner>, Response.ErrorListener {

    private static final String TAG = makeLogTag(PartnerFavoriteRequest.class);

    private static PartnerFavoriteRequest ourInstance;
    private Application app;

    public static PartnerFavoriteRequest getInstance(Application app) {
        if (ourInstance == null) {
            ourInstance = new PartnerFavoriteRequest(app);
        }
        return ourInstance;
    }

    private PartnerFavoriteRequest() {}
    private PartnerFavoriteRequest(Application app) {
        this.app = app;
    }

    public void executeGetAll(String s) {
        String url = ProximitiesConstants.access().getWS_PARTNER_AUTOCOMPLETE()+"?s=" + s;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app.getApplicationContext(), "GET&" + url);
        GsonRequest<BaseFavoritePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseFavoritePartner.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
    }

    @Override
    public void onResponse(BaseFavoritePartner baseFavoritePartner) {
        ProximitiesConstants.STATIC_CONTENT_HOST = baseFavoritePartner.getServerUrl();
        LOGD(TAG, "static url : " + baseFavoritePartner.getServerUrl());
        EventBus.getDefault().post(baseFavoritePartner);
    }
}
