package com.proximities.sdk.fragment.dialog;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.List;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * Created by william on 24/06/15.
 */
public class SimplePushFragment extends DialogFragment{

    private Campaign campaign;
    private TextView title;
    private TextView message;
    private static List<Campaign> campaigns;
    private static boolean isMulti;

    public static SimplePushFragment newInstance(boolean multi, List<Campaign> anims) {
        campaigns = anims;
        SimplePushFragment simplePushFragment = new SimplePushFragment();
        simplePushFragment.setCancelable(false);
        isMulti = multi;
        return simplePushFragment;
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog(getActivity());
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN);
        dialog.setContentView(R.layout.simple_push_dialog);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

        LinearLayout dialogLayout = (LinearLayout) dialog.findViewById(R.id.dialog_layout);
        //GradientDrawable drawable = (GradientDrawable) dialogLayout.getBackground();
        //drawable.setStroke(2, ContextCompat.getColor(getActivity(), ProximitiesConfig.getInstance().getColorDialog()));
        title = (TextView) dialog.findViewById(R.id.title);
        title.setTextColor(ContextCompat.getColor(getActivity(), ProximitiesConfig.getInstance().getColorTitleDialog()));
        GradientDrawable drawable = (GradientDrawable) title.getBackground();
        drawable.setColor(ContextCompat.getColor(getActivity(), ProximitiesConfig.getInstance().getColorDialog()));

        Button closeButton = (Button) dialog.findViewById(R.id.close_button);
        Drawable drawableClose = ContextCompat.getDrawable(getActivity(), R.drawable.ic_clear);
        drawableClose.setColorFilter(new PorterDuffColorFilter(ContextCompat.getColor(getActivity(), ProximitiesConfig.getInstance().getColorTitleDialog()), PorterDuff.Mode.MULTIPLY));
        closeButton.setBackground(drawableClose);

        Button positiveButton = (Button) dialog.findViewById(R.id.positive_button);
        //drawable = (GradientDrawable) positiveButton.getBackground();
        //drawable.setColor(ContextCompat.getColor(getActivity(), ProximitiesConfig.getInstance().getColorDialog()));
        positiveButton.setTextColor(ContextCompat.getColor(getActivity(), ProximitiesConfig.getInstance().getColorDialog()));


        message = (TextView) dialog.findViewById(R.id.message);

        if(ProximitiesConfig.getInstance().getFontDialog() != null) {
            title.setTypeface(ProximitiesConfig.getInstance().getFontDialog());
            message.setTypeface(ProximitiesConfig.getInstance().getFontDialog());
            positiveButton.setTypeface(ProximitiesConfig.getInstance().getFontDialog());
        }

        positiveButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!isMulti || campaigns.size() <= 1) {
                    try {
                        Intent i;
                        if (ProximitiesConfig.getInstance().isUsingCurrentActivity()) {
                            i = new Intent(getActivity(), Class.forName(ProximitiesConfig.getInstance().getCurrentActivity()));
                            i.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
                        } else {
                            i = new Intent(getActivity(), Class.forName(ProximitiesConfig.getMainActivity(getActivity())));
                        }
                        startActivity(i);
                    } catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if(ProximitiesConfig.getOnHandleSimpleAnimationListener() != null){
                    ProximitiesConfig.getOnHandleSimpleAnimationListener().onHandleIdentifier(campaign.getIdentifier());
                }
                campaigns.remove(campaign);
                dismiss();
                if (!isMulti || campaigns.size() == 0)
                    getActivity().finish();
                else
                    EventBus.getDefault().postSticky(campaigns);

            }
        });

        closeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                campaigns.remove(campaign);
                if(isMulti && campaigns.size() == 0){
                    try {
                        Intent i;
                        if (ProximitiesConfig.getInstance().isUsingCurrentActivity()) {
                            i = new Intent(getActivity(), Class.forName(ProximitiesConfig.getInstance().getCurrentActivity()));
                            i.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
                        } else {
                            i = new Intent(getActivity(), Class.forName(ProximitiesConfig.getMainActivity(getActivity())));
                        }
                        startActivity(i);
                    } catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                dismiss();
                if(!isMulti || campaigns.size() == 0)
                    getActivity().finish();
                else
                    EventBus.getDefault().postSticky(campaigns);
            }
        });

        return dialog;
    }

    /**
     * Retrieve informations sent by {@link com.proximities.sdk.ProximitiesAnimationActivity}
     *
     * @param data  {@link Campaign} object
     */
    @Subscribe(sticky=true)
    public void onEventMainThread(Campaign data) {
        campaign = data;
        if (campaign.getTemplateType() != null && campaign.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF)) {
            title.setText(campaign.getPoiName());
            message.setText(campaign.getTitle());
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    public void onPause() {
        EventBus.getDefault().unregister(this);
        super.onPause();
    }
}
