package com.proximities.sdk.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.adapter.FavoriteListAdapter;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 08/01/15.
 */

public class FavoritesFragment extends BaseFavoritesFragment{

    private SwipeRefreshLayout refreshLayout;
    private ProgressBar spinner;
    private RecyclerView recycler;
    private TextView reconnection;
    private List<Campaign> favorites = new ArrayList<>();
    private FavoriteListAdapter adapter;
    private Campaign defaultAnim;
    private static String urlDefaultFavorite;

    public static FavoritesFragment newInstance(String urlDefaultFav) {
        urlDefaultFavorite = urlDefaultFav;
        return new FavoritesFragment();
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fav_fragment, container, false);
        recycler = (RecyclerView) v.findViewById(R.id.recycler_fav);
        reconnection = (TextView) v.findViewById(R.id.reconnection);
        spinner = (ProgressBar) v.findViewById(R.id.spinner);
        refreshLayout = (SwipeRefreshLayout) v.findViewById(R.id.swipe_container);
        refreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                refreshFavorites();
            }
        });
        spinner.getIndeterminateDrawable().setColorFilter(ContextCompat.getColor(getActivity(), R.color.orange), android.graphics.PorterDuff.Mode.MULTIPLY);
        reconnection.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                refreshFavorites();
            }
        });
        reconnection.setVisibility(View.GONE);
        recycler.setVisibility(View.VISIBLE);
        defaultAnim = new Campaign();
        setEmptyFavorites();
        adapter = new FavoriteListAdapter(getActivity(), favorites, this);
        recycler.setAdapter(adapter);
        return v;
    }

    @Override
    public void onResume() {
        super.onResume();
        spinner.setVisibility(View.VISIBLE);
        refreshFavorites();
    }

    @Override
    public void onReceiveFavorites(List<Campaign> favorites) {
        super.onReceiveFavorites(favorites);
        refreshLayout.setRefreshing(true);
        reconnection.setVisibility(View.GONE);
        spinner.setVisibility(View.GONE);
        recycler.setVisibility(View.VISIBLE);
        this.favorites.clear();
        if(favorites != null && favorites.size() > 0){
            this.favorites.addAll(favorites);
        } else {
            this.favorites.add(defaultAnim);
        }
        adapter.notifyDataSetChanged();
        refreshLayout.setRefreshing(false);
    }

    @Override
    public void onErrorCallbackFavorites() {
        super.onErrorCallbackFavorites();
        spinner.setVisibility(View.GONE);
        reconnection.setVisibility(View.VISIBLE);
        recycler.setVisibility(View.GONE);
    }

    private void setEmptyFavorites(){
        defaultAnim.setTitle(getResources().getString(R.string.welcome));
        defaultAnim.setType(ProximitiesConstants.TYPE_INFORMATION);
        defaultAnim.setContentBackgroundColor("#FFFFFF");
        defaultAnim.setContentFontColor("#000000");
        defaultAnim.setTopbarFontColor("#000000");
        defaultAnim.setTopbarBackgroundColor("#FFFFFF");
        defaultAnim.setTopbarTitle(getResources().getString(R.string.welcome));
        defaultAnim.setContentText("<center>" + getResources().getString(R.string.anim_example_content) + "</center>");
        defaultAnim.setContentTitle(getResources().getString(R.string.anim_example_title));
        defaultAnim.setTemplateType(ProximitiesConstants.RICH_NOTIF);
        defaultAnim.setTopbarButton("favorites");
        defaultAnim.setBanner("");
        defaultAnim.setImage(urlDefaultFavorite);
    }

    @Override
    public void onStart() {
        super.onStart();
        recycler.setLayoutManager(new GridLayoutManager(getActivity(), 2));
    }

    @Override
    public void onStop() {
        super.onStop();
    }
}
