package com.proximities.sdk;

import android.Manifest;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Patterns;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;
import com.proximities.sdk.json.model.transmitter.BaseQrCode;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;

import org.greenrobot.eventbus.EventBus;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 22/08/16.
 */
public class ScannerQrActivity extends Activity{

    private static final int MY_PERMISSIONS_REQUEST_CAMERA = 1;
    private static final String TAG = makeLogTag(QRCodeRequest.class);


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.scanner_qr_activity);
        if(ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED){
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.CAMERA},
                    MY_PERMISSIONS_REQUEST_CAMERA);
        } else {
            startScanner();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String permissions[], @NonNull int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_CAMERA: {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    startScanner();
                } else {
                    finish();
                }
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, intent);
        if (scanResult != null && resultCode == RESULT_OK) {
            handleContentQr(scanResult.getContents());
        } else {
            if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onErrorResponse();
            finish();
        }
    }

    private void startScanner(){
        IntentIntegrator intentIntegrator = new IntentIntegrator(this);
        intentIntegrator.setScanningRectangle(800,800);
        intentIntegrator.initiateScan();
    }

    private void handleContentQr(String contentQr){
        if(Patterns.WEB_URL.matcher(contentQr).matches()) {
            try {
                contentQr = (!contentQr.startsWith("http://") && !contentQr.startsWith("https://")) ? "http://"+contentQr : contentQr;
                Intent i = new Intent("android.intent.action.MAIN");
                i.setComponent(ComponentName.unflattenFromString("com.android.chrome/com.android.chrome.Main"));
                i.addCategory("android.intent.category.LAUNCHER");
                i.setData(Uri.parse(contentQr));
                startActivity(i);
            }
            catch(ActivityNotFoundException e1) {
                try{
                    Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(contentQr));
                    startActivity(i);
                } catch (ActivityNotFoundException e2) {
                    if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onErrorResponse();
                }
            }
        } else if (contentQr.startsWith(getResources().getString(R.string.qr_code_prefix))){
            Uri content = Uri.parse(contentQr);
            QRCodeRequest qrCodeRequest = new QRCodeRequest();
            if(content.getQueryParameter("uuid") != null && !content.getQueryParameter("uuid").isEmpty()
                    && content.getQueryParameter("maj") != null && !content.getQueryParameter("maj").isEmpty()
                    && content.getQueryParameter("min") != null && !content.getQueryParameter("min").isEmpty()) {
                qrCodeRequest.executeGet(content.getQueryParameter("uuid"), content.getQueryParameter("maj"), content.getQueryParameter("min"));
            }
        } else {
            if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onUnknownQrCodeResponse();
        }
        finish();
    }

    public final class QRCodeRequest implements Response.Listener<BaseQrCode>, Response.ErrorListener {

        public QRCodeRequest() {
        }

        public void executeGet(String uuid, String major, String minor) {
            String url = ProximitiesConstants.access().getWS_TRANSMITTERS() + "/" + uuid + "/" + major + "/" + minor;
            LOGD(TAG, "GET : " + url);
            Map<String, String> params = Header.getInstance().makeHeader(getApplicationContext(), "GET&" + url);
            GsonRequest<BaseQrCode> request = new GsonRequest(
                    Request.Method.GET,
                    url,
                    BaseQrCode.class,
                    params,
                    this,
                    this);
            ApplicationUtil.getMyInstance().getRequestQueue().add(request);
        }

        @Override
        public void onResponse(BaseQrCode baseTransmitter) {
            if (baseTransmitter != null) {
                ProximitiesConstants.STATIC_CONTENT_HOST = baseTransmitter.getServerUrl();
                EventBus.getDefault().post(baseTransmitter);
            }
        }

        @Override
        public void onErrorResponse(VolleyError volleyError) {
            if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onErrorResponse();
        }

    }
}
