package com.proximities.sdk;

import android.Manifest;
import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;

import com.google.android.gms.maps.model.LatLng;
import com.proximities.sdk.bridge.OnAccessLocationListener;
import com.proximities.sdk.bridge.OnCampaignURLClickListener;
import com.proximities.sdk.bridge.OnCustomMenuCampaignListener;
import com.proximities.sdk.bridge.OnHandleSimpleAnimationListener;
import com.proximities.sdk.bridge.OnItemWebViewClickListener;
import com.proximities.sdk.bridge.OnLocationChangeListener;
import com.proximities.sdk.bridge.OnManageMenuAnimationListener;
import com.proximities.sdk.bridge.OnResponseFromQrScanListener;
import com.proximities.sdk.bridge.OnRetrievePartnersListener;
import com.proximities.sdk.bridge.OnScannedBeaconsListener;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.request.api.FeedRequest;
import com.proximities.sdk.request.api.RegisterUserRequest;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.ProximitiesPrefs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by william on 04/05/15.
 *
 * Allows SDK users to configure several features
 */

public class ProximitiesConfig {

    public static final String TYPE_ALL = "";
    public static final String TYPE_INFORMATION = "information";
    public static final String TYPE_PROMOTION = "promotion";
    public static final String TYPE_EVENT = "event";
    public static final String TYPE_CULTURE = "culture";

    public static final String RICH_CAMPAIGN     = "rich-notification";
    public static final String WEB_CAMPAIGN   = "webview-notification";
    public static final String SIMPLE_CAMPAIGN     = "simple-notification";
    public static final String AUDIO_CAMPAIGN = "audio-notification";
    public static final String VIDEO_CAMPAIGN     = "video-notification";
    public static final String LOYALTY_CAMPAIGN     = "loyalty-notification";
    private static ProximitiesConfig ourInstance = null;

    public static ProximitiesConfig getInstance(){
        if(ourInstance == null)
            ourInstance = new ProximitiesConfig();
        return ourInstance;
    }

    public static List<Campaign> getFavorites() {
        return favorites;
    }

    public static void setFavorites(List<Campaign> favorites) {
        ProximitiesConfig.favorites = favorites;
    }

    private static List<Campaign> favorites;

    public int getTitleCampaigns() {
        return titleCampaigns;
    }
    public static int getNotificationIcon(Context ctx) {
        return ProximitiesPrefs.readNotificationIcon(ctx);
    }
    public static int getNotificationContent(Context ctx) {
        return ProximitiesPrefs.readContentNotification(ctx);
    }
    public static int getNotificationLightColor(Context ctx) {
        return ProximitiesPrefs.readLightColorNotification(ctx);
    }
    public int getColorToolbarCampaigns() {
        return colorToolbarCampaigns;
    }
    public int getColorTitleCampaigns() {
        return colorTitleCampaigns;
    }
    public int getColorTitleDialog() {
        return colorTitleDialog;
    }
    public int getColorDialog() {
        return colorDialog;
    }
    public boolean isFavDisable() {
        return isFavDisable;
    }
    public static String getMainActivity(Context ctx) {
        return ProximitiesPrefs.readMainActivity(ctx);
    }
    public String getCurrentActivity() {
        return currentActivity;
    }
    public boolean isUsingCurrentActivity() {
        return isUsingCurrentActivity;
    }
    public static boolean isEntryExitLogEnabled() {
        return isEntryExitLogEnabled;
    }
    public boolean isDialogBeforeDeepLinkEnabled() {
        return isDialogBeforeDeepLinkEnabled;
    }

    public Typeface getFontDialog() {
        return fontDialog;
    }

    private int titleCampaigns = R.string.multiple_anim_title;
    private int colorTitleCampaigns = android.R.color.white;
    private int colorToolbarCampaigns = android.R.color.black;
    private int colorTitleDialog = android.R.color.white;
    private int colorDialog = R.color.orange;
    private Typeface fontDialog = null;
    private int addFavoritesResource = R.drawable.ic_favorite_empty;
    private int delFavoritesResource = R.drawable.ic_favorite_full;
    private boolean isFavDisable = false;
    private String currentActivity = "";
    private boolean isUsingCurrentActivity = false;
    private static boolean isEntryExitLogEnabled = false;
    private boolean isDialogBeforeDeepLinkEnabled = true;


    /**
     * Initialize the SweepinConnect Sdk. Needs to be called as soon as possible (in the onCreate() of your application class).
     * @param app Your application class
     */
    public static void initSweepinConnectSdk(Application app){
        ApplicationUtil.newInstance(app);
        Test test = new Test();
    }

    /**
     * Enable SweepinConnect by asking the location permission (>= API 23) or directly starting all SweepinConnect features.
     * @param openSettings You can choose to display a settings screen to show the user what features he needs to enable.
     */
    public static void startSweepinConnect(Context context, boolean openSettings){
        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        LocationManager locationManager = (LocationManager) context.getSystemService(context.LOCATION_SERVICE);
        if(ProximitiesPrefs.readAskBleAgain(context) && openSettings && (!wifi.isWifiEnabled() || (mBluetoothAdapter != null && !mBluetoothAdapter.isEnabled()) || !locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER))){
            Intent i = new Intent(context, SettingsActivity.class);
            i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(i);
        } else if(ContextCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                Intent i = new Intent(context, PermissionDialogActivity.class);
                i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(i);
        } else {
            Intent i = new Intent(context, ProximitiesService.class);
            context.startService(i);
        }
    }

    /**
     * Set the main activity of the application which means this activity
     * will be brought to front when a campaign is closed after reception and selection among notifications (app killed only).
     * @param mainActivity main activity of the application
     */
    public static void setMainActivity(Context ctx, Class mainActivity){
        ProximitiesPrefs.writeMainActivity(ctx ,mainActivity.getCanonicalName());
    }

    /**
     * If enabled a dialog is displayed to the user when a simple notification is received.
     * He can choose to close this dialog if he is not interested in which case the deep link will be ignored.
     * @param isEnabled
     */
    public void enableDialogBeforeDeepLink(boolean isEnabled){
        isDialogBeforeDeepLinkEnabled = isEnabled;
    }

    /**
     * Saves the activity the user was on before receiving a campaign
     * @param currentActivity
     */
    public void saveCurrentActivity(Class currentActivity){
        isUsingCurrentActivity = true;
        this.currentActivity = currentActivity.getCanonicalName();
    }

    /**
     * Customize the activity displayed when multiple campaigns are received simultaneously.
     * @param title
     * @param colorTitle
     * @param colorToolbar
     */
    public void setMultiCampaignsStyle(int title, int colorTitle, int colorToolbar){
        titleCampaigns = title;
        colorTitleCampaigns = colorTitle;
        colorToolbarCampaigns = colorToolbar;
    }

    /**
     * Customize the simple notification dialog.
     * @param colorDialog
     * @param colorTitle
     * @param font
     */
    public void setSimplePushDialogDesign(int colorDialog, int colorTitle, Typeface font){
        this.colorDialog = colorDialog;
        colorTitleDialog = colorTitle;
        fontDialog = font;
    }

    /**
     * You can choose to receive campaigns without the possibility for the user to add them to their favorites
     * @param disableFav true to disable, false if not
     */
    public void disableFavorites(boolean disableFav){
        isFavDisable = disableFav;
    }

    /**
     * This function allows to enable the display of campaigns or to disable it.
     * Important : if you used this function to disable campaigns, you need to reuse it at some point in your code to enable the display again.
     * @param disable true if enable, false if not
     */
    public static void disableAllCampaigns(Context ctx, boolean disable){
        ProximitiesPrefs.writeDisableAnim(ctx, disable);
    }

    /**
     * Set the icon of notifications when campaigns are received
     * @param ctx context
     * @param notificationIcon icon of the notification
     */
    public static void setNotificationStyle(Context ctx, int notificationIcon, int multiCampaignsContent, int lightColor){
        ProximitiesPrefs.writeNotificationIcon(ctx, notificationIcon);
        ProximitiesPrefs.writeContentNotification(ctx, multiCampaignsContent);
        ProximitiesPrefs.writeLightColorNotification(ctx, lightColor);
    }

    /**
     * Allows developers to define duration relative variables when app is in foreground
     * @param foregroundScanPeriod duration of a scan
     * @param foregroundBetweenScanPeriod duration between two scans
     */
    public static void setForegroundScanPeriod(Context ctx, int foregroundScanPeriod, int foregroundBetweenScanPeriod){
        ProximitiesPrefs.writeForegroundScanPeriod(ctx, foregroundScanPeriod, foregroundBetweenScanPeriod);
    }

    /**
     * Allows developers to define duration relative variables when app is not in foreground (background or killed)
     * @param backgroundScanPeriod duration of a scan
     * @param backgroundBetweenScanPeriod duration between two scans
     */
    public static void setBackgroundScanPeriod(Context ctx, int backgroundScanPeriod, int backgroundBetweenScanPeriod){
        ProximitiesPrefs.writeBackgroundScanPeriod(ctx, backgroundScanPeriod, backgroundBetweenScanPeriod);
    }

    /**
     * The identifier can be anything so as the keys in the map.
     *   Example :
     *   Map<String, String> parameters = new HashMap<>();
     *   parameters.put("email", "test@test.fr");
     *   parameters.put("age", 30);
     *   ..
     *   ProximitiesConfig.registerUser("test@test.fr", parameters, this);
     */
    public static void registerUser(String identifier, Map<String, String> parameters, Activity activity){
        try {
            Map<String, Object> body = new HashMap<>();
            body.put("identifier", identifier);
            body.put("parameters", parameters);
            RegisterUserRequest userReq = new RegisterUserRequest(activity);
            userReq.sendRegisterUser(body);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     *   Add a fragment at the bottom of rich campaigns allowing users to share the content
     *   @param shareFragment fragment to display
     */
    public void setShareFragment(Context c, Class shareFragment){
        ProximitiesPrefs.writeShareFragment(c, shareFragment.getCanonicalName());
    }


    /**
     * Request an update of the user's location
     */
    public static void requestLocationUpdate(){
        if(ProximitiesGpsManager.getInstance() != null)
            ProximitiesGpsManager.getInstance().startPolling();
    }

    /**
     * Set your own icons to customize the favorite menu item present on a campaign
     * @param addFavoritesResource resource for adding the campaigns in favorites
     * @param deleteFavoritesResource resource for deleting the campaign of favorites
     */
    public void setFavoritesIcons(int addFavoritesResource, int deleteFavoritesResource){
        this.addFavoritesResource = addFavoritesResource;
        this.delFavoritesResource = deleteFavoritesResource;
    }

    /**
     * Set the location priority for the location request.
     * @param priority default is LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY
     */
    public static void setLocationPriority(int priority){
        ProximitiesGpsManager.getInstance().setLocationPriority(priority);
    }

    public static void enableEntryExitLog(boolean enable){
        isEntryExitLogEnabled = enable;
    }

    /**
     * Get active partners with campaigns available.
     * @param nbElements The 'nbElements' closest active partners from the user's location
     * @param campaignType The type of campaign you want to retrieve
     *                      ProximitiesConfig.TYPE_ALL
     *                      ProximitiesConfig.TYPE_INFORMATION
     *                      ProximitiesConfig.TYPE_PROMOTION
     *                      ProximitiesConfig.TYPE_EVENT
     *                      ProximitiesConfig.TYPE_CULTURE
     */
    public static void getPartners(int nbElements, String campaignType){
        FeedRequest feedRequest = FeedRequest.getInstance();
        feedRequest.executeGet(ProximitiesConstants.access().getWS_FEED() + "/"
                + ProximitiesPrefs.readCurrentLat(ApplicationUtil.getMyInstance().getMyApp()) + "/"
                + ProximitiesPrefs.readCurrentLng(ApplicationUtil.getMyInstance().getMyApp()) + "?page=" + 1 + "&size=" + nbElements + "&type=" + campaignType + ";");
    }

    /**
     * Get the last known location of the user.
     * @return last known location
     */
    public static LatLng getLastKnownLocation(Context context){
        return new LatLng(ProximitiesPrefs.readCurrentLat(context), ProximitiesPrefs.readCurrentLng(context));
    }

    /**
     * Start a QR Code scanner to scan Sweepin Qr Code or to open a web url
     */
    public static void startQrCodeScanner(Context context){
        context.startActivity(new Intent(context, ScannerQrActivity.class));
    }

    //// * Listeners * ////

    protected static OnAccessLocationListener getOnAccessLocationListener() {
        return onAccessLocationListener;
    }
    public static OnHandleSimpleAnimationListener getOnHandleSimpleAnimationListener() {
        return onHandleSimpleAnimationListener;
    }

    public static OnManageMenuAnimationListener getOnManageMenuAnimationListener() {
        return onManageMenuAnimationListener;
    }

    public static OnCustomMenuCampaignListener getOnCustomMenuCampaignListener() {
        return onCustomMenuCampaignListener;
    }

    public static OnItemWebViewClickListener getOnItemWebViewClickListener() {
        return onItemWebViewClickListener;
    }

    public static OnRetrievePartnersListener getOnRetrievePartnersListener() {
        return onRetrievePartnersListener;
    }

    public static OnScannedBeaconsListener getOnScannedBeaconsListener() {
        return onScannedBeaconsListener;
    }

    public static OnLocationChangeListener getOnLocationChangeListener() {
        return onLocationChangeListener;
    }

    public static OnResponseFromQrScanListener getOnResponseFromQrScanListener() {
        return onResponseFromQrScanListener;
    }

    public static OnCampaignURLClickListener getOnCampaignURLClickListener() {
        return onCampaignURLClickListener;
    }

    private static OnLocationChangeListener onLocationChangeListener;
    private static OnHandleSimpleAnimationListener onHandleSimpleAnimationListener;
    private static OnAccessLocationListener onAccessLocationListener;
    private static OnManageMenuAnimationListener onManageMenuAnimationListener;
    private static OnCustomMenuCampaignListener onCustomMenuCampaignListener;
    private static OnItemWebViewClickListener onItemWebViewClickListener;
    private static OnCampaignURLClickListener onCampaignURLClickListener;
    private static OnRetrievePartnersListener onRetrievePartnersListener;
    private static OnScannedBeaconsListener onScannedBeaconsListener;
    private static OnResponseFromQrScanListener onResponseFromQrScanListener;

    public static void setOnLocationChangeListener(OnLocationChangeListener locationChangeListener){
        onLocationChangeListener = locationChangeListener;
    }

    /**
     * Callback to retrieve the identifier of a simple notification.
     */
    public static void setOnHandleSimpleAnimationListener(OnHandleSimpleAnimationListener handleSimpleAnimationListener){
        onHandleSimpleAnimationListener = handleSimpleAnimationListener;
    }

    /**
     * Callback after the user's response to the location permission. (> API 23)
     */
    public static void setOnAccessLocationListener(OnAccessLocationListener accessLocationListener){
        onAccessLocationListener = accessLocationListener;
    }

    /**
     * Callback to replace the favorite menu item by your own menu on all campaigns.
     *
     * @deprecated use {@link #addOnCustomMenuCampaignListener(OnCustomMenuCampaignListener)} instead
     */
    @Deprecated
    public static void setOnManageMenuAnimationListener(OnManageMenuAnimationListener manageMenuListener){
        onManageMenuAnimationListener = manageMenuListener;
    }

    /**
     * Callback to replace the favorite menu item by your own menu on all campaigns.
     */
    public static void addOnCustomMenuCampaignListener(OnCustomMenuCampaignListener customMenuCampaignListener){
        onCustomMenuCampaignListener = customMenuCampaignListener;
    }

    /**
     * Callback to replace the favorite menu item by your own menu on all campaigns.
     *
     * @deprecated use {@link #setOnCampaignURLClickListener(OnCampaignURLClickListener)} instead
     */
    @Deprecated
    public static void setOnItemWebViewClickListener(OnItemWebViewClickListener itemWebViewClickListener){
        onItemWebViewClickListener = itemWebViewClickListener;
    }

    public static void setOnCampaignURLClickListener(OnCampaignURLClickListener listener){
        onCampaignURLClickListener = listener;
    }

    /**
     * Callback to retrieve a list of active partners.
     */
    public static void setOnRetrievePartnersListener(OnRetrievePartnersListener retrievePartnersListener){
        onRetrievePartnersListener = retrievePartnersListener;
    }

    /**
     * Callback to retrieve the list of scanned beacons.
     */
    public static void setOnScannedBeaconsListener(OnScannedBeaconsListener scannedBeaconsListener){
        onScannedBeaconsListener = scannedBeaconsListener;
    }

    /**
     * Callback to handle specific situations occuring after a Qr Code scan.
     */
    public static void setOnResponseFromQrScanListener(OnResponseFromQrScanListener responseFromQrScanListener){
        onResponseFromQrScanListener = responseFromQrScanListener;
    }

}

