package com.proximities.sdk;

import android.bluetooth.BluetoothAdapter;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;

import com.proximities.sdk.fragment.dialog.BluetoothFragment;
import com.proximities.sdk.message.EnableBluetooth;

import org.greenrobot.eventbus.EventBus;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 02/01/15.
 */
public class BluetoothActivity extends FragmentActivity implements BluetoothFragment.BluetoothClickListener {

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BluetoothFragment bleFrag = BluetoothFragment.newInstance();
        bleFrag.show(getSupportFragmentManager(), "ble");
    }

    @Override
    public void onBluetoothEnabled(boolean enabled) {
        if (enabled) {
            BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            mBluetoothAdapter.enable();
        }
        Log.d("ENABLED", " IT IS ON");
        EventBus.getDefault().post(EnableBluetooth.getInstance());
        finish();
    }
}
