/*
 * Decompiled with CFR 0.152.
 */
package com.github.sviperll.tasks;

import com.github.sviperll.tasks.AdditionalClosingActionTask;
import com.github.sviperll.tasks.CloseOnEachRunTask;
import com.github.sviperll.tasks.ClosingTask;
import com.github.sviperll.tasks.ConfigurableTask;
import com.github.sviperll.tasks.DoNothingTask;
import com.github.sviperll.tasks.ExceptionSwallowingTask;
import com.github.sviperll.tasks.FactoryTask;
import com.github.sviperll.tasks.LoggingTask;
import com.github.sviperll.tasks.ParallelTask;
import com.github.sviperll.tasks.RepeatingTask;
import com.github.sviperll.tasks.RunnableTask;
import com.github.sviperll.tasks.SequenceTask;
import com.github.sviperll.tasks.Task;
import com.github.sviperll.tasks.TaskFactory;
import com.github.sviperll.tasks.TaskRunnable;
import com.github.sviperll.tasks.UnstoppableTask;
import com.github.sviperll.tasks.WithoutCloseTask;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class Tasks {
    private static final ConfigurableTask DO_NOTHING_TASK = new ConfigurableTask(new DoNothingTask());

    public static Thread spawn(Task task) {
        Thread thread = new Thread(new TaskRunnable(task));
        thread.start();
        return thread;
    }

    public static ConfigurableTask runnable(Runnable runnable) {
        return new ConfigurableTask(new RunnableTask(runnable));
    }

    public static ConfigurableTask factory(TaskFactory factory) {
        return new ConfigurableTask(new FactoryTask(factory));
    }

    public static ConfigurableTask repeat(Task task, long pause, TimeUnit unit) {
        return new ConfigurableTask(new RepeatingTask(task, unit.toMillis(pause)));
    }

    public static ConfigurableTask repeat(Task task) {
        return Tasks.repeat(task, 0L, TimeUnit.MILLISECONDS);
    }

    public static ConfigurableTask log(Task task, Logger logger, String name) {
        return new ConfigurableTask(new LoggingTask(name, logger, task));
    }

    public static ConfigurableTask swallowExceptions(Task task, Logger logger, long pause, TimeUnit unit) {
        return new ConfigurableTask(new ExceptionSwallowingTask(task, logger, unit.toMillis(pause)));
    }

    public static ConfigurableTask doNothing() {
        return DO_NOTHING_TASK;
    }

    public static ConfigurableTask sequence(Task ... tasks) {
        return new ConfigurableTask(new SequenceTask(tasks));
    }

    public static ConfigurableTask sequence(List<? extends Task> tasks) {
        Task[] taskArray = tasks.toArray(new Task[tasks.size()]);
        return Tasks.sequence(taskArray);
    }

    public static ConfigurableTask parallel(Task ... tasks) {
        return new ConfigurableTask(new ParallelTask(tasks));
    }

    public static ConfigurableTask parallel(List<? extends Task> tasks) {
        Task[] taskArray = tasks.toArray(new Task[tasks.size()]);
        return Tasks.parallel(taskArray);
    }

    public static ConfigurableTask closeAfterEachRun(Task task) {
        return new ConfigurableTask(new CloseOnEachRunTask(task));
    }

    public static ConfigurableTask configure(Task task) {
        if (task instanceof ConfigurableTask) {
            return (ConfigurableTask)task;
        }
        return new ConfigurableTask(task);
    }

    public static ConfigurableTask unstoppable(Task task) {
        return new ConfigurableTask(new UnstoppableTask(task));
    }

    public static ConfigurableTask withoutClose(Task task) {
        return new ConfigurableTask(new WithoutCloseTask(task));
    }

    public static ConfigurableTask closingTaskFor(Task task) {
        return new ConfigurableTask(new ClosingTask(task));
    }

    public static ConfigurableTask withAdditinalClosingAction(Task task, Runnable closingAction) {
        return new ConfigurableTask(new AdditionalClosingActionTask(task, closingAction));
    }
}

