/*
 * Decompiled with CFR 0.152.
 */
package com.github.sviperll.tasks;

import com.github.sviperll.tasks.Task;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoggingTask
implements Task {
    private final String name;
    private final Logger logger;
    private final Task task;

    public LoggingTask(String name, Logger logger, Task task) {
        this.name = name;
        this.logger = logger;
        this.task = task;
    }

    @Override
    public void stop() {
        this.logger.log(Level.FINE, "{0}: exiting...", this.name);
        this.task.stop();
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "{0}: started", this.name);
        this.task.run();
        this.logger.log(Level.FINE, "{0}: finished", this.name);
    }

    @Override
    public void close() {
        this.logger.log(Level.FINE, "{0}: closing...", this.name);
        this.task.close();
        this.logger.log(Level.FINE, "{0}: closed", this.name);
    }
}

