/*
 * Decompiled with CFR 0.152.
 */
package com.github.sviperll.tasks;

import com.github.sviperll.tasks.Task;
import java.util.logging.Level;
import java.util.logging.Logger;

class ExceptionSwallowingTask
implements Task {
    private final Task task;
    private final Logger logger;
    private final long pause;

    public ExceptionSwallowingTask(Task task, Logger logger, long pause) {
        this.task = task;
        this.logger = logger;
        this.pause = pause;
    }

    @Override
    public void stop() {
        try {
            this.task.stop();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
            try {
                Thread.sleep(this.pause);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
            try {
                Thread.sleep(this.pause);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        try {
            this.task.close();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
            try {
                Thread.sleep(this.pause);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

