/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundeepk.compactcalendarview.domain;

import android.support.annotation.Nullable;

public class Event {
    private int color;
    private long timeInMillis;
    private Object data;

    public Event(int color, long timeInMillis) {
        this.color = color;
        this.timeInMillis = timeInMillis;
    }

    public Event(int color, long timeInMillis, Object data) {
        this.color = color;
        this.timeInMillis = timeInMillis;
        this.data = data;
    }

    public int getColor() {
        return this.color;
    }

    public long getTimeInMillis() {
        return this.timeInMillis;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.color != event.color) {
            return false;
        }
        if (this.timeInMillis != event.timeInMillis) {
            return false;
        }
        return !(this.data != null ? !this.data.equals(event.data) : event.data != null);
    }

    public int hashCode() {
        int result = this.color;
        result = 31 * result + (int)(this.timeInMillis ^ this.timeInMillis >>> 32);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Event{color=" + this.color + ", timeInMillis=" + this.timeInMillis + ", data=" + this.data + '}';
    }
}

