/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.feedback;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.IApp;
import com.github.stkent.amplify.IDevice;
import com.github.stkent.amplify.IEnvironment;
import com.github.stkent.amplify.feedback.BaseEmailFeedbackCollector;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DefaultEmailFeedbackCollector
extends BaseEmailFeedbackCollector {
    public DefaultEmailFeedbackCollector(String ... recipients) {
        super(recipients);
    }

    @Override
    @NonNull
    protected String getSubjectLine(@NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        return app.getName() + " Android App Feedback";
    }

    @Override
    @NonNull
    protected String getBody(@NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        String androidVersionString = String.format("%s (%s)", environment.getAndroidVersionName(), environment.getAndroidVersionCode());
        String appVersionString = String.format("%s (%s)", app.getVersionName(), app.getVersionCode());
        return "Time Stamp: " + this.getCurrentUtcTimeStringForDate(new Date()) + "\nApp Version: " + appVersionString + "\nInstall Source: " + app.getInstallSource() + "\nAndroid Version: " + androidVersionString + "\nDevice Manufacturer: " + device.getManufacturer() + "\nDevice Model: " + device.getModel() + "\nDisplay Resolution: " + device.getResolution() + "\nDisplay Density (Actual): " + device.getActualDensity() + "\nDisplay Density (Bucket) " + device.getDensityBucket() + "\n---------------------\n\n";
    }

    @NonNull
    private String getCurrentUtcTimeStringForDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.getDefault());
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }
}

