/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.IEnvironment;
import java.util.List;

public final class Environment
implements IEnvironment {
    private static final String AMAZON_APP_STORE_PACKAGE_NAME = "com.amazon.venezia";
    private static final String GOOGLE_PLAY_STORE_PACKAGE_NAME = "com.android.vending";
    @NonNull
    private final Context appContext;

    public Environment(@NonNull Context context) {
        this.appContext = context.getApplicationContext();
    }

    @Override
    @NonNull
    public String getAndroidVersionName() {
        return Build.VERSION.RELEASE;
    }

    @Override
    public int getAndroidVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public boolean isAppInstalled(@NonNull String packageName) {
        return this.getPackageInfo(packageName, 1) != null;
    }

    @Override
    public boolean isAmazonAppStoreInstalled() {
        return this.isAppInstalled(AMAZON_APP_STORE_PACKAGE_NAME);
    }

    @Override
    public boolean isGooglePlayStoreInstalled() {
        return this.isAppInstalled(GOOGLE_PLAY_STORE_PACKAGE_NAME);
    }

    @Override
    public boolean canHandleIntent(@NonNull Intent intent) {
        List resolveInfoList = this.appContext.getPackageManager().queryIntentActivities(intent, 65536);
        return !resolveInfoList.isEmpty();
    }

    @Nullable
    private PackageInfo getPackageInfo(@NonNull String packageName, int flags) {
        PackageManager packageManager = this.appContext.getPackageManager();
        try {
            return packageManager.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return null;
        }
    }
}

