/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import com.github.stkent.amplify.IDevice;
import java.util.Locale;

public final class Device
implements IDevice {
    @NonNull
    private final String resolution;
    @NonNull
    private final String actualDensity;
    @NonNull
    private final String densityBucket;

    @NonNull
    private static String getDensityBucketString(@NonNull DisplayMetrics displayMetrics) {
        switch (displayMetrics.densityDpi) {
            case 120: {
                return "ldpi";
            }
            case 160: {
                return "mdpi";
            }
            case 240: {
                return "hdpi";
            }
            case 320: {
                return "xhdpi";
            }
            case 480: {
                return "xxhdpi";
            }
            case 640: {
                return "xxxhdpi";
            }
            case 213: {
                return "tvdpi";
            }
        }
        return "Unknown";
    }

    public Device(@NonNull Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.resolution = displayMetrics.heightPixels + "x" + displayMetrics.widthPixels;
        this.actualDensity = displayMetrics.densityDpi + "dpi";
        this.densityBucket = Device.getDensityBucketString(displayMetrics);
    }

    @Override
    @NonNull
    public String getManufacturer() {
        return Build.MANUFACTURER.toUpperCase(Locale.US);
    }

    @Override
    @NonNull
    public String getModel() {
        return Build.MODEL.toUpperCase(Locale.US);
    }

    @Override
    @NonNull
    public String getResolution() {
        return this.resolution;
    }

    @Override
    @NonNull
    public String getActualDensity() {
        return this.actualDensity;
    }

    @Override
    @NonNull
    public String getDensityBucket() {
        return this.densityBucket;
    }
}

