/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import com.github.stkent.amplify.tracking.managers.BaseEventsManager;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public final class LastEventTimeRulesManager
extends BaseEventsManager<Long> {
    public LastEventTimeRulesManager(@NonNull ISettings<Long> settings, @NonNull ILogger logger) {
        super(settings, logger);
    }

    @Override
    @NonNull
    protected String getTrackedEventDimensionDescription() {
        return "Last time";
    }

    @Override
    @NonNull
    protected String getEventTrackingStatusStringSuffix(@NonNull Long cachedEventValue) {
        Long daysSinceLastEvent = TimeUnit.MILLISECONDS.toDays(SystemTimeUtil.currentTimeMillis() - cachedEventValue);
        return "last occurred " + daysSinceLastEvent + " days ago";
    }

    @Override
    @NonNull
    public Long getUpdatedTrackingValue(@Nullable Long cachedTrackingValue) {
        return SystemTimeUtil.currentTimeMillis();
    }
}

