/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.BasePromptViewConfig;
import com.github.stkent.amplify.prompt.interfaces.IPromptPresenter;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.prompt.interfaces.IQuestionPresenter;
import com.github.stkent.amplify.prompt.interfaces.IQuestionView;
import com.github.stkent.amplify.prompt.interfaces.IThanksView;

abstract class BasePromptView<T extends View, U extends View>
extends FrameLayout
implements IPromptView {
    private T displayedQuestionView;
    private boolean displayed;
    private final IQuestionPresenter userOpinionQuestionPresenter = new IQuestionPresenter(){

        @Override
        public void userRespondedPositively() {
            BasePromptView.this.promptPresenter.setUserOpinion(IPromptPresenter.UserOpinion.POSITIVE);
        }

        @Override
        public void userRespondedNegatively() {
            BasePromptView.this.promptPresenter.setUserOpinion(IPromptPresenter.UserOpinion.NEGATIVE);
        }
    };
    private final IQuestionPresenter feedbackQuestionPresenter = new IQuestionPresenter(){

        @Override
        public void userRespondedPositively() {
            BasePromptView.this.promptPresenter.userAgreedToGiveFeedback();
        }

        @Override
        public void userRespondedNegatively() {
            BasePromptView.this.promptPresenter.userDeclinedToGiveFeedback();
        }
    };
    private IPromptPresenter promptPresenter;
    private BasePromptViewConfig basePromptViewConfig;

    protected abstract boolean isConfigured();

    @NonNull
    protected abstract T getQuestionView();

    @Nullable
    protected abstract U getThanksView();

    BasePromptView(Context context) {
        this(context, null);
    }

    BasePromptView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    BasePromptView(Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.initializeBaseConfig(attributeSet);
    }

    @Override
    public final void setPresenter(@NonNull IPromptPresenter promptPresenter) {
        this.promptPresenter = promptPresenter;
    }

    @Override
    public final void queryUserOpinion() {
        if (!this.isConfigured()) {
            throw new IllegalStateException("PromptView is not fully configured.");
        }
        T userOpinionQuestionView = this.getQuestionView();
        ((IQuestionView)userOpinionQuestionView).setPresenter(this.userOpinionQuestionPresenter);
        ((IQuestionView)userOpinionQuestionView).bind(this.basePromptViewConfig.getUserOpinionQuestion());
        this.setContentView((View)userOpinionQuestionView);
        this.displayedQuestionView = userOpinionQuestionView;
        this.displayed = true;
    }

    @Override
    public final void requestPositiveFeedback() {
        ((IQuestionView)this.displayedQuestionView).setPresenter(this.feedbackQuestionPresenter);
        ((IQuestionView)this.displayedQuestionView).bind(this.basePromptViewConfig.getPositiveFeedbackQuestion());
    }

    @Override
    public final void requestCriticalFeedback() {
        T criticalFeedbackQuestionView = this.getQuestionView();
        ((IQuestionView)criticalFeedbackQuestionView).setPresenter(this.feedbackQuestionPresenter);
        ((IQuestionView)criticalFeedbackQuestionView).bind(this.basePromptViewConfig.getCriticalFeedbackQuestion());
        this.setContentView((View)criticalFeedbackQuestionView);
    }

    @Override
    public final void thankUser() {
        U thanksView = this.getThanksView();
        ((IThanksView)thanksView).bind(this.basePromptViewConfig.getThanks());
        this.setContentView((View)thanksView);
        this.promptPresenter = null;
    }

    @Override
    public final void dismiss() {
        this.setVisibility(8);
        this.promptPresenter = null;
    }

    @Override
    public boolean providesThanksView() {
        return this.getThanksView() != null;
    }

    public void applyBaseConfig(@NonNull BasePromptViewConfig basePromptViewConfig) {
        this.basePromptViewConfig = basePromptViewConfig;
    }

    protected boolean isDisplayed() {
        return this.displayed;
    }

    private void initializeBaseConfig(@Nullable AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.BasePromptView, 0, 0);
        this.basePromptViewConfig = new BasePromptViewConfig(typedArray);
        typedArray.recycle();
    }

    private void setContentView(@NonNull View view) {
        this.removeAllViews();
        this.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }
}

