/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.IAppFeedbackDataProvider;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.utils.ActivityStateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class FeedbackUtil {
    private static final String DEFAULT_EMAIL_SUBJECT_LINE_SUFFIX = " Android App Feedback";
    private final IAppFeedbackDataProvider appFeedbackDataProvider;
    private final IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider;
    private final ILogger logger;
    private final String feedbackEmailAddress;

    public FeedbackUtil(@NonNull IAppFeedbackDataProvider appFeedbackDataProvider, @NonNull IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider, @NonNull String feedbackEmailAddress, @NonNull ILogger logger) {
        this.appFeedbackDataProvider = appFeedbackDataProvider;
        this.environmentCapabilitiesProvider = environmentCapabilitiesProvider;
        this.feedbackEmailAddress = feedbackEmailAddress;
        this.logger = logger;
    }

    public void showFeedbackEmailChooser(@Nullable Activity activity) {
        Intent feedbackEmailIntent = this.getFeedbackEmailIntent();
        if (!this.environmentCapabilitiesProvider.canHandleIntent(feedbackEmailIntent)) {
            this.logger.e("Unable to present email client chooser.");
            return;
        }
        if (ActivityStateUtil.isActivityValid(activity)) {
            activity.startActivity(Intent.createChooser((Intent)feedbackEmailIntent, (CharSequence)"Choose an email provider:"));
            activity.overridePendingTransition(0, 0);
        }
    }

    @NonNull
    private Intent getFeedbackEmailIntent() {
        Intent result = new Intent("android.intent.action.SENDTO");
        result.setData(Uri.parse((String)"mailto:"));
        result.putExtra("android.intent.extra.EMAIL", new String[]{this.feedbackEmailAddress});
        result.putExtra("android.intent.extra.SUBJECT", this.getEmailSubjectLine());
        result.putExtra("android.intent.extra.TEXT", this.getAppInfoString());
        return result;
    }

    @NonNull
    private String getEmailSubjectLine() {
        return this.appFeedbackDataProvider.getAppNameString() + DEFAULT_EMAIL_SUBJECT_LINE_SUFFIX;
    }

    @NonNull
    private String getAppInfoString() {
        return "My Device: " + this.appFeedbackDataProvider.getDeviceName() + "\n" + "App Version: " + this.appFeedbackDataProvider.getVersionDisplayString() + "\n" + "Android Version: " + this.getAndroidOsVersionDisplayString() + "\n" + "Time Stamp: " + this.getCurrentUtcTimeStringForDate(new Date()) + "\n" + "---------------------" + "\n\n";
    }

    @NonNull
    private String getAndroidOsVersionDisplayString() {
        return String.format("%s (%s)", Build.VERSION.RELEASE, Build.VERSION.SDK_INT);
    }

    @NonNull
    private String getCurrentUtcTimeStringForDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.getDefault());
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }
}

