/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IAppInfoProvider;

public class AppInfoProvider
implements IAppInfoProvider {
    private static final Object SYNC_LOCK = new Object();
    private static AppInfoProvider sharedInstance;
    private final Context appContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(@NonNull Context context) {
        Object object = SYNC_LOCK;
        synchronized (object) {
            if (sharedInstance == null) {
                sharedInstance = new AppInfoProvider(context);
            }
        }
    }

    @NonNull
    public static AppInfoProvider getSharedInstance() {
        if (sharedInstance == null) {
            throw new IllegalStateException("Must initialize AppInfoProvider before calling getSharedInstance.");
        }
        return sharedInstance;
    }

    public static void setSharedInstance(@NonNull AppInfoProvider sharedInstance) {
        AppInfoProvider.sharedInstance = sharedInstance;
    }

    private AppInfoProvider(@NonNull Context appContext) {
        this.appContext = appContext;
    }

    @Override
    @NonNull
    public PackageInfo getPackageInfo() {
        return this.getPackageInfo(this.appContext.getPackageName(), 0);
    }

    @Override
    public PackageInfo getPackageInfo(@NonNull String packageName, int flags) {
        PackageManager packageManager = this.appContext.getPackageManager();
        try {
            return packageManager.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    @Override
    @NonNull
    public PackageManager getPackageManager() {
        return this.appContext.getPackageManager();
    }

    @Override
    @NonNull
    public ApplicationInfo getApplicationInfo() {
        return this.appContext.getApplicationInfo();
    }
}

