/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.Settings;
import com.github.stkent.amplify.tracking.interfaces.IAppInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import com.github.stkent.amplify.tracking.managers.BaseEventsManager;

public class LastEventVersionRulesManager
extends BaseEventsManager<String> {
    @NonNull
    private final IAppInfoProvider appInfoProvider;

    public LastEventVersionRulesManager(@NonNull Context appContext, @NonNull IAppInfoProvider appInfoProvider, @NonNull ILogger logger) {
        this(new Settings<String>(appContext), appInfoProvider, logger);
    }

    protected LastEventVersionRulesManager(@NonNull ISettings<String> settings, @NonNull IAppInfoProvider appInfoProvider, @NonNull ILogger logger) {
        super(settings, logger);
        this.appInfoProvider = appInfoProvider;
    }

    @Override
    @NonNull
    protected String getTrackedEventDimensionDescription() {
        return "Last version name";
    }

    @Override
    @NonNull
    protected String getEventTrackingStatusStringSuffix(@NonNull String cachedEventValue) {
        return " last occurred for app version name " + cachedEventValue;
    }

    @Override
    @NonNull
    public String getUpdatedTrackingValue(@Nullable String cachedTrackingValue) {
        return this.appInfoProvider.getPackageInfo().versionName;
    }
}

