/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.Settings;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import com.github.stkent.amplify.tracking.managers.BaseEventsManager;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public class FirstEventTimeRulesManager
extends BaseEventsManager<Long> {
    public FirstEventTimeRulesManager(@NonNull Context appContext, @NonNull ILogger logger) {
        this((ISettings<Long>)new Settings<Long>(appContext), logger);
    }

    protected FirstEventTimeRulesManager(@NonNull ISettings<Long> settings, @NonNull ILogger logger) {
        super(settings, logger);
    }

    @Override
    @NonNull
    protected String getTrackedEventDimensionDescription() {
        return "First time";
    }

    @Override
    @NonNull
    protected String getEventTrackingStatusStringSuffix(@NonNull Long cachedEventValue) {
        Long daysSinceFirstEvent = TimeUnit.MILLISECONDS.toDays(SystemTimeUtil.currentTimeMillis() - cachedEventValue);
        return " first occurred " + daysSinceFirstEvent + " days ago";
    }

    @Override
    @NonNull
    public Long getUpdatedTrackingValue(@Nullable Long cachedTrackingValue) {
        long currentTimeMillis = SystemTimeUtil.currentTimeMillis();
        if (cachedTrackingValue == null) {
            return currentTimeMillis;
        }
        return Math.min(cachedTrackingValue, currentTimeMillis);
    }
}

