/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.AmplifyExceptionHandler;
import com.github.stkent.amplify.tracking.interfaces.IAppEventTimeProvider;
import com.github.stkent.amplify.tracking.interfaces.IAppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventsManager;
import com.github.stkent.amplify.tracking.managers.LastEventTimeRulesManager;
import com.github.stkent.amplify.tracking.rules.CooldownDaysRule;

public class AppLevelEventRulesManager
implements IAppLevelEventRulesManager {
    private static final IEvent APP_CRASHED = new IEvent(){

        @Override
        @NonNull
        public String getTrackingKey() {
            return "APP_CRASHED";
        }
    };
    @NonNull
    private final Context appContext;
    @NonNull
    private final ILogger logger;
    @NonNull
    private final IAppEventTimeProvider appEventTimeProvider;
    @Nullable
    private IEventBasedRule<Long> installTimeRule;
    @Nullable
    private IEventBasedRule<Long> lastUpdateTimeRule;
    @Nullable
    private IEventsManager<Long> lastEventTimeRulesManager;

    public AppLevelEventRulesManager(@NonNull Context appContext, @NonNull IAppEventTimeProvider appEventTimeProvider, @NonNull ILogger logger) {
        this.appContext = appContext;
        this.appEventTimeProvider = appEventTimeProvider;
        this.logger = logger;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        boolean result = true;
        if (this.installTimeRule != null) {
            long installTime = this.appEventTimeProvider.getInstallTime();
            boolean installResult = this.installTimeRule.shouldAllowFeedbackPrompt(installTime);
            if (!installResult) {
                this.logger.d("Blocking prompt based on install time");
            }
            result = installResult;
        }
        if (this.lastUpdateTimeRule != null) {
            long lastUpdateTime = this.appEventTimeProvider.getLastUpdateTime();
            boolean lastUpdateResult = this.lastUpdateTimeRule.shouldAllowFeedbackPrompt(lastUpdateTime);
            if (!lastUpdateResult) {
                this.logger.d("Blocking prompt based on last update time");
            }
            boolean bl = result = result && lastUpdateResult;
        }
        if (this.lastEventTimeRulesManager != null) {
            result = result && this.lastEventTimeRulesManager.shouldAllowFeedbackPrompt();
        }
        return result;
    }

    @Override
    public void setInstallTimeCooldownDays(int cooldownPeriodDays) {
        this.installTimeRule = new CooldownDaysRule(cooldownPeriodDays);
        this.logger.d("Registered " + this.installTimeRule.getDescription() + " for event APP_INSTALLED");
    }

    @Override
    public void setLastUpdateTimeCooldownDays(int cooldownPeriodDays) {
        this.lastUpdateTimeRule = new CooldownDaysRule(cooldownPeriodDays);
        this.logger.d("Registered " + this.lastUpdateTimeRule.getDescription() + " for event APP_UPDATED");
    }

    @Override
    public void setLastCrashTimeCooldownDays(int cooldownPeriodDays) {
        this.lastEventTimeRulesManager = new LastEventTimeRulesManager(this.appContext, this.logger);
        this.lastEventTimeRulesManager.addEventBasedRule(APP_CRASHED, new CooldownDaysRule(cooldownPeriodDays));
        Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(defaultUncaughtExceptionHandler instanceof AmplifyExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new AmplifyExceptionHandler(this, Thread.getDefaultUncaughtExceptionHandler()));
        }
    }

    @Override
    public void notifyOfCrash() {
        if (this.lastEventTimeRulesManager != null) {
            this.lastEventTimeRulesManager.notifyEventTriggered(APP_CRASHED);
        }
    }
}

