/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.utils.AppInfoProvider;

public final class VersionChangedRule
implements IEventBasedRule<String> {
    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull String cachedEventValue) {
        String currentAppVersion = AppInfoProvider.getSharedInstance().getPackageInfo().versionName;
        return !cachedEventValue.equals(currentAppVersion);
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull String cachedEventValue) {
        String suffix = "Current app version: " + AppInfoProvider.getSharedInstance().getPackageInfo().versionName;
        return "Event last triggered for app version " + cachedEventValue + ". " + suffix;
    }
}

