/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.BasePromptView;
import com.github.stkent.amplify.prompt.CustomLayoutPromptViewConfig;
import com.github.stkent.amplify.prompt.CustomLayoutQuestionView;
import com.github.stkent.amplify.prompt.CustomLayoutThanksView;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;

public final class CustomLayoutPromptView
extends BasePromptView<CustomLayoutQuestionView, CustomLayoutThanksView>
implements IPromptView {
    private CustomLayoutPromptViewConfig config;

    public CustomLayoutPromptView(Context context) {
        this(context, null);
    }

    public CustomLayoutPromptView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CustomLayoutPromptView(Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.init(attributeSet);
    }

    public void applyConfig(@NonNull CustomLayoutPromptViewConfig config) {
        if (this.isDisplayed()) {
            throw new IllegalStateException("Configuration cannot be changed after the prompt is first displayed.");
        }
        this.config = config;
    }

    @Override
    protected boolean isConfigured() {
        return this.config.isValid();
    }

    @Override
    @NonNull
    protected CustomLayoutQuestionView getQuestionView() {
        return new CustomLayoutQuestionView(this.getContext(), this.config.getQuestionLayout());
    }

    @Override
    @Nullable
    protected CustomLayoutThanksView getThanksView() {
        if (this.config.getThanksLayout() != null) {
            return new CustomLayoutThanksView(this.getContext(), this.config.getThanksLayout());
        }
        return null;
    }

    private void init(@Nullable AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.CustomLayoutPromptView, 0, 0);
        this.config = new CustomLayoutPromptViewConfig(typedArray);
        typedArray.recycle();
    }
}

