/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.utils.ActivityStateUtil;

public final class PlayStoreUtil {
    private static final String ANDROID_MARKET_URI_PREFIX = "market://details?id=";
    private static final String GOOGLE_PLAY_STORE_URI_PREFIX = "https://play.google.com/store/apps/details?id=";

    private PlayStoreUtil() {
    }

    public static void openPlayStoreToRate(@Nullable Activity activity, @Nullable String packageName) {
        if (ActivityStateUtil.isActivityValid(activity)) {
            try {
                activity.startActivity(new Intent("android.intent.action.VIEW", PlayStoreUtil.getAndroidMarketUriForPackageName(packageName)));
            }
            catch (ActivityNotFoundException e) {
                activity.startActivity(new Intent("android.intent.action.VIEW", PlayStoreUtil.getGooglePlayStoreUriForPackageName(packageName)));
            }
            finally {
                activity.overridePendingTransition(0x10A0000, 0x10A0001);
            }
        }
    }

    @NonNull
    private static Uri getAndroidMarketUriForPackageName(@NonNull String packageName) {
        return Uri.parse((String)(ANDROID_MARKET_URI_PREFIX + packageName));
    }

    @NonNull
    private static Uri getGooglePlayStoreUriForPackageName(@NonNull String packageName) {
        return Uri.parse((String)(GOOGLE_PLAY_STORE_URI_PREFIX + packageName));
    }
}

