/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.ApplicationVersionNameProvider;
import com.github.stkent.amplify.tracking.interfaces.IApplicationFeedbackDataProvider;
import com.github.stkent.amplify.tracking.interfaces.IApplicationVersionNameProvider;
import com.github.stkent.amplify.utils.ApplicationUtils;
import com.github.stkent.amplify.utils.StringUtils;

public class ApplicationFeedbackDataProvider
implements IApplicationFeedbackDataProvider {
    @NonNull
    private final Context applicationContext;
    @NonNull
    private final IApplicationVersionNameProvider applicationVersionNameProvider;

    public ApplicationFeedbackDataProvider(@NonNull Context applicationContext) {
        this.applicationContext = applicationContext;
        this.applicationVersionNameProvider = new ApplicationVersionNameProvider(applicationContext);
    }

    @Override
    @NonNull
    public String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        String deviceName = model.startsWith(manufacturer) ? StringUtils.capitalize(model) : StringUtils.capitalize(manufacturer) + " " + model;
        return deviceName == null ? "Unknown Device" : deviceName;
    }

    @Override
    @NonNull
    public String getVersionDisplayString() throws PackageManager.NameNotFoundException {
        int applicationVersionCode = ApplicationUtils.getPackageInfo((Context)this.applicationContext).versionCode;
        return String.format("%s (%s)", this.applicationVersionNameProvider.getVersionName(), applicationVersionCode);
    }

    @Override
    @NonNull
    public CharSequence getApplicationNameString() throws PackageManager.NameNotFoundException {
        ApplicationInfo applicationInfo = ApplicationUtils.getPackageInfo((Context)this.applicationContext).applicationInfo;
        return applicationInfo.loadLabel(this.applicationContext.getPackageManager());
    }
}

