/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public final class StringUtils {
    private StringUtils() {
    }

    @NonNull
    public static <T extends CharSequence> T defaultIfBlank(@Nullable T primaryString, @NonNull T defaultString) {
        return StringUtils.isBlank(primaryString) ? defaultString : primaryString;
    }

    @Nullable
    public static String capitalize(@Nullable String string) {
        char newChar;
        if (StringUtils.isBlank(string)) {
            return string;
        }
        char firstChar = string.charAt(0);
        if (firstChar == (newChar = Character.toUpperCase(firstChar))) {
            return string;
        }
        int strLen = string.length();
        char[] newChars = new char[strLen];
        newChars[0] = newChar;
        string.getChars(1, strLen, newChars, 1);
        return String.valueOf(newChars);
    }

    public static boolean isBlank(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        int sequenceLength = charSequence.length();
        if (sequenceLength == 0) {
            return true;
        }
        for (int i = 0; i < sequenceLength; ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

