/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.utils.ApplicationUtils;
import java.util.List;

public final class EnvironmentCapabilitiesProvider
implements IEnvironmentCapabilitiesProvider {
    private static final String GOOGLE_PLAY_STORE_PACKAGE_NAME = "com.android.vending";
    @NonNull
    private final Context applicationContext;

    public EnvironmentCapabilitiesProvider(@NonNull Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean isApplicationInstalled(@NonNull String packageName) {
        try {
            ApplicationUtils.getPackageInfo(this.applicationContext, packageName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isGooglePlayStoreInstalled() {
        return this.isApplicationInstalled(GOOGLE_PLAY_STORE_PACKAGE_NAME);
    }

    @Override
    public boolean canHandleIntent(@NonNull Intent intent) {
        List resolveInfoList = this.applicationContext.getPackageManager().queryIntentActivities(intent, 65536);
        return !resolveInfoList.isEmpty();
    }
}

