/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.Logger;
import com.github.stkent.amplify.tracking.AmplifyViewEvent;
import com.github.stkent.amplify.tracking.ApplicationEventTrackingDataProvider;
import com.github.stkent.amplify.tracking.ApplicationVersionNameProvider;
import com.github.stkent.amplify.tracking.EnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.tracking.checks.CooldownDaysCheck;
import com.github.stkent.amplify.tracking.checks.GooglePlayStoreIsAvailableCheck;
import com.github.stkent.amplify.tracking.checks.MaximumCountCheck;
import com.github.stkent.amplify.tracking.checks.VersionChangedCheck;
import com.github.stkent.amplify.tracking.interfaces.IAmplifyStateTracker;
import com.github.stkent.amplify.tracking.interfaces.IApplicationChecksManager;
import com.github.stkent.amplify.tracking.interfaces.IApplicationVersionNameProvider;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCheck;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentChecksManager;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.tracking.interfaces.ITrackableEvent;
import com.github.stkent.amplify.tracking.managers.ApplicationChecksManager;
import com.github.stkent.amplify.tracking.managers.EnvironmentChecksManager;
import com.github.stkent.amplify.tracking.managers.FirstEventTimesManager;
import com.github.stkent.amplify.tracking.managers.LastEventTimesManager;
import com.github.stkent.amplify.tracking.managers.LastEventVersionsManager;
import com.github.stkent.amplify.tracking.managers.TotalEventCountsManager;
import com.github.stkent.amplify.views.AmplifyView;

public final class AmplifyStateTracker
implements IAmplifyStateTracker {
    private static AmplifyStateTracker sharedInstance;
    private static final int DEFAULT_USER_GAVE_POSITIVE_FEEDBACK_MAXIMUM_COUNT = 7;
    private static final int DEFAULT_INSTALL_TIME_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_LAST_UPDATE_TIME_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_USER_DECLINED_CRITICAL_FEEDBACK_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_USER_DECLINED_POSITIVE_FEEDBACK_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_USER_GAVE_CRITICAL_FEEDBACK_COOLDOWN_DAYS = 7;
    private final IApplicationVersionNameProvider applicationVersionNameProvider;
    private final IApplicationChecksManager applicationChecksManager;
    private final IEnvironmentChecksManager environmentChecksManager;
    private final FirstEventTimesManager firstEventTimesManager;
    private final LastEventTimesManager lastEventTimesManager;
    private final LastEventVersionsManager lastEventVersionsManager;
    private final TotalEventCountsManager totalEventCountsManager;
    private final ILogger logger;
    private boolean alwaysShow;

    public static AmplifyStateTracker get(@NonNull Context context) {
        return AmplifyStateTracker.get(context, new Logger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmplifyStateTracker get(@NonNull Context context, @NonNull ILogger logger) {
        Class<AmplifyStateTracker> clazz = AmplifyStateTracker.class;
        synchronized (AmplifyStateTracker.class) {
            if (sharedInstance == null) {
                sharedInstance = new AmplifyStateTracker(context, logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private AmplifyStateTracker(@NonNull Context context, @NonNull ILogger logger) {
        Context applicationContext = context.getApplicationContext();
        ApplicationEventTrackingDataProvider applicationInfoProvider = new ApplicationEventTrackingDataProvider(applicationContext);
        EnvironmentCapabilitiesProvider environmentInfoProvider = new EnvironmentCapabilitiesProvider(applicationContext);
        this.applicationVersionNameProvider = new ApplicationVersionNameProvider(applicationContext);
        this.applicationChecksManager = new ApplicationChecksManager(applicationContext, applicationInfoProvider, logger);
        this.environmentChecksManager = new EnvironmentChecksManager(environmentInfoProvider);
        this.firstEventTimesManager = new FirstEventTimesManager(applicationContext, logger);
        this.lastEventTimesManager = new LastEventTimesManager(applicationContext, logger);
        this.lastEventVersionsManager = new LastEventVersionsManager(applicationContext, logger);
        this.totalEventCountsManager = new TotalEventCountsManager(applicationContext, logger);
        this.logger = logger;
    }

    public AmplifyStateTracker configureWithDefaults() {
        return this.addEnvironmentCheck(new GooglePlayStoreIsAvailableCheck()).setInstallTimeCooldownDays(7).setLastCrashTimeCooldownDays(7).trackTotalEventCount(AmplifyViewEvent.USER_GAVE_POSITIVE_FEEDBACK, new MaximumCountCheck(7)).trackLastEventTime(AmplifyViewEvent.USER_GAVE_CRITICAL_FEEDBACK, new CooldownDaysCheck(7L)).trackLastEventTime(AmplifyViewEvent.USER_DECLINED_CRITICAL_FEEDBACK, new CooldownDaysCheck(7L)).trackLastEventTime(AmplifyViewEvent.USER_DECLINED_POSITIVE_FEEDBACK, new CooldownDaysCheck(7L)).trackLastEventVersion(AmplifyViewEvent.USER_DECLINED_CRITICAL_FEEDBACK, new VersionChangedCheck(this.applicationVersionNameProvider)).trackLastEventVersion(AmplifyViewEvent.USER_DECLINED_POSITIVE_FEEDBACK, new VersionChangedCheck(this.applicationVersionNameProvider)).trackLastEventVersion(AmplifyViewEvent.USER_GAVE_CRITICAL_FEEDBACK, new VersionChangedCheck(this.applicationVersionNameProvider));
    }

    public AmplifyStateTracker setLogLevel(@NonNull Logger.LogLevel logLevel) {
        this.logger.setLogLevel(logLevel);
        return this;
    }

    public AmplifyStateTracker setAlwaysShow(boolean alwaysShow) {
        this.alwaysShow = alwaysShow;
        return this;
    }

    public AmplifyStateTracker setInstallTimeCooldownDays(int cooldownPeriodDays) {
        this.applicationChecksManager.setInstallTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public AmplifyStateTracker setLastUpdateTimeCooldownDays(int cooldownPeriodDays) {
        this.applicationChecksManager.setLastUpdateTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public AmplifyStateTracker setLastCrashTimeCooldownDays(int cooldownPeriodDays) {
        this.applicationChecksManager.setLastCrashTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public AmplifyStateTracker trackTotalEventCount(@NonNull ITrackableEvent event, @NonNull IEventCheck<Integer> eventCheck) {
        this.totalEventCountsManager.trackEvent(event, eventCheck);
        return this;
    }

    public AmplifyStateTracker trackFirstEventTime(@NonNull ITrackableEvent event, @NonNull IEventCheck<Long> eventCheck) {
        this.firstEventTimesManager.trackEvent(event, eventCheck);
        return this;
    }

    public AmplifyStateTracker trackLastEventTime(@NonNull ITrackableEvent event, @NonNull IEventCheck<Long> eventCheck) {
        this.lastEventTimesManager.trackEvent(event, eventCheck);
        return this;
    }

    public AmplifyStateTracker trackLastEventVersion(@NonNull ITrackableEvent event, @NonNull IEventCheck<String> eventCheck) {
        this.lastEventVersionsManager.trackEvent(event, eventCheck);
        return this;
    }

    public AmplifyStateTracker addEnvironmentCheck(@NonNull IEnvironmentCheck environmentCheck) {
        this.environmentChecksManager.addEnvironmentCheck(environmentCheck);
        return this;
    }

    @Override
    public AmplifyStateTracker notifyEventTriggered(@NonNull ITrackableEvent event) {
        this.logger.d("Triggered Event: " + event);
        this.totalEventCountsManager.notifyEventTriggered(event);
        this.firstEventTimesManager.notifyEventTriggered(event);
        this.lastEventTimesManager.notifyEventTriggered(event);
        this.lastEventVersionsManager.notifyEventTriggered(event);
        return this;
    }

    public void promptIfReady(@NonNull AmplifyView amplifyView) {
        if (this.shouldAskForRating()) {
            amplifyView.injectDependencies(this, this.logger);
            amplifyView.show();
        }
    }

    public boolean shouldAskForRating() {
        return this.alwaysShow | this.applicationChecksManager.shouldAllowFeedbackPrompt() & this.environmentChecksManager.shouldAllowFeedbackPrompt() & this.totalEventCountsManager.shouldAllowFeedbackPrompt() & this.firstEventTimesManager.shouldAllowFeedbackPrompt() & this.lastEventTimesManager.shouldAllowFeedbackPrompt() & this.lastEventVersionsManager.shouldAllowFeedbackPrompt();
    }
}

