/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentInfoProvider;
import com.github.stkent.amplify.utils.ActivityStateUtil;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;

public final class FeedbackUtil {
    private final IApplicationInfoProvider applicationInfoProvider;
    private final IEnvironmentInfoProvider environmentInfoProvider;
    private final ILogger logger;

    public FeedbackUtil(@NonNull IApplicationInfoProvider applicationInfoProvider, @NonNull IEnvironmentInfoProvider environmentInfoProvider, @NonNull ILogger logger) {
        this.applicationInfoProvider = applicationInfoProvider;
        this.environmentInfoProvider = environmentInfoProvider;
        this.logger = logger;
    }

    public void showFeedbackEmailChooser(@Nullable Activity activity) {
        Intent feedbackEmailIntent = this.getFeedbackEmailIntent();
        if (!this.environmentInfoProvider.canHandleIntent(feedbackEmailIntent)) {
            this.logger.e("Unable to present email client chooser.");
            return;
        }
        if (ActivityStateUtil.isActivityValid(activity)) {
            activity.startActivity(Intent.createChooser((Intent)this.getFeedbackEmailIntent(), (CharSequence)"Choose an email provider:"));
            activity.overridePendingTransition(0, 0);
        }
    }

    @NonNull
    private Intent getFeedbackEmailIntent() {
        String feedbackEmailSubject = Uri.encode((String)"Android App Feedback", (String)"UTF-8");
        String appInfo = this.getApplicationInfoString();
        StringBuilder uriStringBuilder = new StringBuilder("mailto:");
        try {
            uriStringBuilder.append(this.applicationInfoProvider.getFeedbackEmailAddress());
        }
        catch (IllegalStateException e) {
            this.logger.e("Feedback email address was not defined");
        }
        uriStringBuilder.append("?subject=").append(feedbackEmailSubject).append("&body=").append(appInfo);
        Uri uri = Uri.parse((String)uriStringBuilder.toString());
        return new Intent("android.intent.action.SENDTO", uri);
    }

    @NonNull
    private String getApplicationInfoString() {
        String applicationVersionDisplayString;
        try {
            applicationVersionDisplayString = this.applicationInfoProvider.getApplicationVersionDisplayString();
        }
        catch (PackageManager.NameNotFoundException e) {
            this.logger.e("Unable to determine application version information.");
            applicationVersionDisplayString = "Unknown";
        }
        return "\n\n\n---------------------\nApp Version: " + applicationVersionDisplayString + "\n" + "Android OS Version: " + this.getAndroidOsVersionDisplayString() + "\n" + "Date: " + SystemTimeUtil.currentTimeMillis();
    }

    private String getAndroidOsVersionDisplayString() {
        return Build.VERSION.RELEASE + " - " + Build.VERSION.SDK_INT;
    }
}

