/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.checks;

import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;

public final class VersionChangedCheck
implements IEventCheck<String> {
    @Override
    public boolean shouldBlockFeedbackPrompt(@NonNull String cachedEventValue, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        try {
            String currentAppVersion = applicationInfoProvider.getVersionName();
            return cachedEventValue.equals(currentAppVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull String cachedEventValue, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        String statusStringSuffix;
        try {
            statusStringSuffix = "Current app version: " + applicationInfoProvider.getVersionName();
        }
        catch (PackageManager.NameNotFoundException e) {
            statusStringSuffix = "Current app version cannot be determined.";
        }
        return "Event last triggered for app version " + cachedEventValue + ". " + statusStringSuffix;
    }
}

