/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.checks;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public final class CooldownDaysCheck
implements IEventCheck<Long> {
    private final long cooldownPeriodDays;

    public CooldownDaysCheck(long cooldownPeriodDays) {
        this.cooldownPeriodDays = cooldownPeriodDays;
    }

    @Override
    public boolean shouldBlockFeedbackPrompt(@NonNull Long cachedEventValue, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        return SystemTimeUtil.currentTimeMillis() - cachedEventValue < TimeUnit.DAYS.toMillis(this.cooldownPeriodDays);
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull Long cachedEventValue, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        Long daysSinceLastEvent = TimeUnit.MILLISECONDS.toDays(SystemTimeUtil.currentTimeMillis() - cachedEventValue);
        return "Cooldown period: " + this.cooldownPeriodDays + " days. Time since last event: " + daysSinceLastEvent + " days.";
    }
}

