/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.Logger;
import com.github.stkent.amplify.tracking.Settings;
import com.github.stkent.amplify.tracking.TrackingUtils;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCheck;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.tracking.interfaces.ILogger;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AmplifyStateTracker {
    private static AmplifyStateTracker sharedInstance;
    private final Context applicationContext;
    private final List<IEnvironmentCheck> environmentRequirements = new ArrayList<IEnvironmentCheck>();
    private final Map<IEvent, List<IEventCheck<Long>>> lastEventTimePredicates = new ConcurrentHashMap<IEvent, List<IEventCheck<Long>>>();
    private final Map<IEvent, List<IEventCheck<String>>> lastEventVersionPredicates = new ConcurrentHashMap<IEvent, List<IEventCheck<String>>>();
    private final Map<IEvent, List<IEventCheck<Integer>>> totalEventCountPredicates = new ConcurrentHashMap<IEvent, List<IEventCheck<Integer>>>();
    private ISettings settings;
    private ILogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmplifyStateTracker get(@NonNull Context context) {
        Class<AmplifyStateTracker> clazz = AmplifyStateTracker.class;
        synchronized (AmplifyStateTracker.class) {
            if (sharedInstance == null) {
                sharedInstance = new AmplifyStateTracker(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public AmplifyStateTracker setLogLevel(@NonNull Logger.LogLevel logLevel) {
        this.getLogger().setLogLevel(logLevel);
        return this;
    }

    private ISettings getSettings() {
        if (this.settings == null) {
            this.settings = Settings.getSharedInstance(this.applicationContext);
        }
        return this.settings;
    }

    private ILogger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private AmplifyStateTracker(@NonNull Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    public AmplifyStateTracker trackTotalEventCount(@NonNull IEvent event, @NonNull IEventCheck<Integer> predicate) {
        this.performEventRelatedInitializationIfRequired(event);
        if (!this.totalEventCountPredicates.containsKey(event)) {
            this.totalEventCountPredicates.put(event, new ArrayList());
        }
        this.totalEventCountPredicates.get(event).add(predicate);
        this.getLogger().d(this.totalEventCountPredicates.get(event).toString());
        return this;
    }

    public AmplifyStateTracker trackLastEventTime(@NonNull IEvent event, @NonNull IEventCheck<Long> predicate) {
        this.performEventRelatedInitializationIfRequired(event);
        if (!this.lastEventTimePredicates.containsKey(event)) {
            this.lastEventTimePredicates.put(event, new ArrayList());
        }
        this.lastEventTimePredicates.get(event).add(predicate);
        this.getLogger().d(this.lastEventTimePredicates.get(event).toString());
        return this;
    }

    public AmplifyStateTracker trackLastEventVersion(@NonNull IEvent event, @NonNull IEventCheck<String> predicate) {
        this.performEventRelatedInitializationIfRequired(event);
        if (!this.lastEventVersionPredicates.containsKey(event)) {
            this.lastEventVersionPredicates.put(event, new ArrayList());
        }
        this.lastEventVersionPredicates.get(event).add(predicate);
        this.getLogger().d(this.lastEventVersionPredicates.get(event).toString());
        return this;
    }

    public AmplifyStateTracker addEnvironmentCheck(@NonNull IEnvironmentCheck requirement) {
        this.environmentRequirements.add(requirement);
        return this;
    }

    public AmplifyStateTracker notifyEventTriggered(@NonNull IEvent event) {
        if (this.totalEventCountPredicates.containsKey(event)) {
            Integer cachedCount = this.getSettings().getTotalEventCount(event);
            Integer updatedCount = cachedCount + 1;
            this.getSettings().setTotalEventCount(event, updatedCount);
        }
        if (this.lastEventTimePredicates.containsKey(event)) {
            Long currentTime = System.currentTimeMillis();
            this.getSettings().setLastEventTime(event, currentTime);
        }
        if (this.lastEventVersionPredicates.containsKey(event)) {
            try {
                String currentVersion = TrackingUtils.getAppVersionName(this.applicationContext);
                this.getSettings().setLastEventVersion(event, currentVersion);
            }
            catch (PackageManager.NameNotFoundException e) {
                this.getLogger().d("Could not read current app version name.");
            }
        }
        return this;
    }

    public boolean shouldAskForRating() {
        return this.allEnvironmentRequirementsMet() && this.allTotalEventCountPredicatesAllowFeedbackPrompt() && this.allLastEventTimePredicatesAllowFeedbackPrompt() && this.allLastEventVersionPredicatesAllowFeedbackPrompt();
    }

    private boolean allEnvironmentRequirementsMet() {
        for (IEnvironmentCheck environmentRequirement : this.environmentRequirements) {
            if (environmentRequirement.isMet(this.applicationContext)) continue;
            return false;
        }
        return true;
    }

    private boolean allTotalEventCountPredicatesAllowFeedbackPrompt() {
        for (Map.Entry<IEvent, List<IEventCheck<Integer>>> eventCheckSet : this.totalEventCountPredicates.entrySet()) {
            IEvent event = eventCheckSet.getKey();
            Integer totalEventCount = this.getSettings().getTotalEventCount(event);
            for (IEventCheck<Integer> predicate : eventCheckSet.getValue()) {
                this.getLogger().d(event.getTrackingKey() + ": " + predicate.getStatusString(totalEventCount, this.applicationContext));
                if (!predicate.shouldBlockFeedbackPrompt(totalEventCount, this.applicationContext)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean allLastEventTimePredicatesAllowFeedbackPrompt() {
        for (Map.Entry<IEvent, List<IEventCheck<Long>>> eventCheckSet : this.lastEventTimePredicates.entrySet()) {
            IEvent event = eventCheckSet.getKey();
            Long lastEventTime = this.getSettings().getLastEventTime(event);
            for (IEventCheck<Long> predicate : eventCheckSet.getValue()) {
                this.getLogger().d(event.getTrackingKey() + ": " + predicate.getStatusString(lastEventTime, this.applicationContext));
                if (!predicate.shouldBlockFeedbackPrompt(lastEventTime, this.applicationContext)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean allLastEventVersionPredicatesAllowFeedbackPrompt() {
        for (Map.Entry<IEvent, List<IEventCheck<String>>> eventCheckSet : this.lastEventVersionPredicates.entrySet()) {
            IEvent event = eventCheckSet.getKey();
            String lastEventVersion = this.getSettings().getLastEventVersion(event);
            if (lastEventVersion == null) continue;
            for (IEventCheck<String> predicate : eventCheckSet.getValue()) {
                this.getLogger().d(event.getTrackingKey() + ": " + predicate.getStatusString(lastEventVersion, this.applicationContext));
                if (!predicate.shouldBlockFeedbackPrompt(lastEventVersion, this.applicationContext)) continue;
                return false;
            }
        }
        return true;
    }

    private void performEventRelatedInitializationIfRequired(@NonNull IEvent event) {
        if (this.isEventAlreadyTracked(event)) {
            return;
        }
        event.performRelatedInitialization(this.applicationContext);
    }

    private boolean isEventAlreadyTracked(@NonNull IEvent event) {
        HashSet<IEvent> allTrackedEvents = new HashSet<IEvent>();
        allTrackedEvents.addAll(this.lastEventTimePredicates.keySet());
        allTrackedEvents.addAll(this.lastEventVersionPredicates.keySet());
        allTrackedEvents.addAll(this.totalEventCountPredicates.keySet());
        return allTrackedEvents.contains(event);
    }
}

