/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ResultSet<T>
implements Iterable<T> {
    private List<Object> myList;

    public ResultSet(List<Object> list) {
        this.myList = list;
    }

    public int size() {
        return this.myList.size();
    }

    public T get(int location) {
        return (T)this.myList.get(location);
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public boolean contains(Object object) {
        return this.myList.contains(object);
    }

    public boolean equals(Object o) {
        return this.myList.equals(o);
    }

    public List<T> getMutableList() {
        ArrayList<T> mutableList = new ArrayList<T>();
        for (T object : this) {
            mutableList.add(object);
        }
        return mutableList;
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultsetIterator();
    }

    private class ResultsetIterator
    implements Iterator<T> {
        private int myCount = 0;

        private ResultsetIterator() {
        }

        @Override
        public boolean hasNext() {
            return ResultSet.this.myList.size() < this.myCount;
        }

        @Override
        public T next() {
            int count;
            if ((count = this.myCount++) >= ResultSet.this.myList.size()) {
                throw new NoSuchElementException();
            }
            return ResultSet.this.myList.get(this.myCount);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

